
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/display/FontHandler.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.display;



import java.awt.font.*;
import java.awt.Font.*;
import java.awt.*;
import edu.virginia.bioch.nopt.options.*;

public class FontHandler
{
	protected Font normalFont;
	protected String normalFontName;
	protected int normalFontSize;
	protected FontMetrics normalFontMetrics;

	protected Font smallFont;
	protected String smallFontName;
	protected int smallFontSize;
	protected FontMetrics smallFontMetrics;

	public FontHandler( Component c )
	{
		normalFontSize = 14;
		normalFontName = "monospaced";
		normalFont = new Font(normalFontName, Font.PLAIN, normalFontSize);

		smallFontSize = 8;
		smallFontName = "serif";
		smallFont = new Font(smallFontName, Font.PLAIN, smallFontSize);

		normalFontMetrics =  c.getFontMetrics( normalFont );
		smallFontMetrics = c.getFontMetrics( smallFont );
	}

	public Font getNormalFont() 
		{ return normalFont; }

	public String getNormalFontName()
		{ return normalFontName; }

	public int getNormalFontSize()
		{ return normalFontSize; }

	public Font getSmallFont() 
		{ return smallFont; }

	public String getSmallFontName()
		{ return smallFontName; }

	public int getSmallFontSize()
		{ return smallFontSize; }

	public FontMetrics getSmallFontMetrics()
		{ return smallFontMetrics; }

	public FontMetrics getNormalFontMetrics()
		{ return normalFontMetrics; }

}
