
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/display/InfoPanel.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.display;



import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.text.*; 

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;

import edu.virginia.bioch.util.*;
import edu.virginia.bioch.scoringmatrices.*;


class InfoPanel extends JPanel
{
	protected DecimalFormat decimal;

	// all of these labels contain fixed values
	protected String seqNames ;
	protected String numAlignments ;

	// all of these labels contain values that will be updated for each
	// alignment
	protected String optimalScore;
	protected String currentScore;
	protected String optimalPercentIdentity;
	protected String currentPercentIdentity;
	protected String optimalPercentSimilarity;
	protected String currentPercentSimilarity;
	protected String matrixName ;
	protected String gapCreate ;
	protected String gapExtend ;

	protected AlignmentHandler ah;

	public InfoPanel(AlignmentHandler ah)
	{
		System.out.println("InfoPanel constructor");
		this.ah = ah;

		Font smallFont = new Font("Times",Font.PLAIN,12);
		Font largeFont = new Font("Times",Font.PLAIN,14);
		decimal = new DecimalFormat();

		seqNames = ah.getSeq1Name() + "   vs.   " + 
		           ah.getSeq2Name();

	}

	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
		//setBackground( new Color(255,240,240) );
		setBackground( Color.white ); 

		// set text each time this is redrawn
		Alignment a = ah.getCurrentAlignment();
		AlignmentParameters ap = a.getAlignmentParameters();

		currentScore = Integer.toString( a.getScore() ); 
		optimalScore = Integer.toString( ap.getOptimalScore() ); 

		currentPercentIdentity = ( 
				decimal.format( 100 * a.getPercentIdentity() ) ); 
		optimalPercentIdentity = ( 
				decimal.format( 100 * ah.getOptimalPercentIdentity() ) ); 

		currentPercentSimilarity = ( 
				decimal.format( 100 * a.getPercentSimilarity() ) ); 
		optimalPercentSimilarity = ( 
				decimal.format( 100 * ah.getOptimalPercentSimilarity() ) ); 

		matrixName = ( ap.getScoringMatrixName() ); 
		gapCreate = ( Integer.toString( ap.getGapCreate() ) ); 
		gapExtend = ( Integer.toString( ap.getGapExtend() ) ); 

		numAlignments =  ah.getNumAlignments() + 
		                " unique alignments, ordered by: " + ah.getOrder() ;

		g.drawString( seqNames , 				20,  20 );

		g.drawString( "Current", 				150, 50 );
		g.drawString( "Optimal", 				210, 50 );

		g.drawString( "Alignment Score", 		20,  70 );
		g.drawString( currentScore, 			150, 70 );
		g.drawString( optimalScore, 			210, 70 );

		g.drawString( "% Identity", 			20,  90 );
		g.drawString( currentPercentIdentity, 	150, 90 );
		g.drawString( optimalPercentIdentity, 	210, 90 );

		g.drawString( "% Similarity", 			 20, 110 );
		g.drawString( currentPercentSimilarity, 150, 110 );
		g.drawString( optimalPercentSimilarity, 210, 110 );


		g.drawString( "for parameters:", 		340, 50 );

		g.drawString( "Scoring Matrix:", 		350, 70 );
		g.drawString( matrixName, 				460, 70 );

		g.drawString( "Gap Open:", 				350, 90 );
		g.drawString( gapCreate, 				460, 90 );

		g.drawString( "Gap Extend:", 			350, 110 );
		g.drawString( gapExtend, 				460, 110 );

		g.drawString( numAlignments, 			20, 140 );

	}
}

