
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/display/SeqComparePanel.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.display;



import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.lang.Thread.*;
import java.util.Vector;
import java.lang.Exception.*;
import java.io.IOException;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.nopt.conditions.*;
import edu.virginia.bioch.nopt.display.path.*;

import edu.virginia.bioch.util.*;


import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;

public class SeqComparePanel extends JPanel
	implements ActionListener, ChangeListener, ItemListener
{
	protected Timer _timer;
	protected AlignmentDisplayPanel displayPanel; 
	protected PathDisplay pathGraph;
	protected InfoPanel infoPanel; 
	protected ControlPanel controlPanel; 
	protected OptionDisplay optionDisplay; 
	protected int fastDelay = 100;
	protected int mediumDelay = 300;
	protected int slowDelay = 1000;
	protected int sliderPrev;
	protected ConditionHandler ch;
	protected AlignmentHandler ah;

	public SeqComparePanel( OptionHandler oh, 
			                FontHandler fh, 
							ConditionHandler ch,
							AlignmentHandler ah,
							OptionSelectionPanel osp,
							ConditionSelectionPanel csp,
							Component parent)
	{
		System.out.println("SeqComparePanel constructor");
		setPreferredSize(new Dimension(800,550));

		this.ah = ah;
		this.ch = ch;

		sliderPrev = 0;

		// display tabs
		JTabbedPane displayTabs = new JTabbedPane();
		displayTabs.setTabPlacement( JTabbedPane.TOP );
		//displayTabs.setBackground( Color.white );

		// pairwise alignment display
		displayPanel = new AlignmentDisplayPanel(oh,fh,ah, 
				                                 new Dimension(750,350) );
		JScrollPane displayScroll = new JScrollPane( displayPanel );
		displayTabs.addTab("Pairwise Alignment", displayScroll);
		displayTabs.setToolTipTextAt(0,
				   "Use controls below to start/stop animation and " +
				   " to annotate/filter alignments shown.");
		displayPanel.addPropertyChangeListener( ch );

	
		// path graph
		pathGraph = new PathDisplay( ah );
		displayTabs.addTab("Zoomable Path Graph", pathGraph );
		displayTabs.setPreferredSize( new Dimension( 800,350 ) );
		displayTabs.setToolTipTextAt(1, 
				   "Hold right-mouse-click and drag to pan display. " +
				   "Hold left-mouse-click and drag to zoom display.");

	
		// control tabs
		JTabbedPane controlTabs = new JTabbedPane();
		controlTabs.setTabPlacement( JTabbedPane.BOTTOM );
		//controlTabs.setBackground( Color.white );

		// control panel
		controlPanel = new ControlPanel(ah,fh,oh,parent);
		controlPanel.setPreferredSize( new Dimension(400,150) );
		controlPanel.addActionListener( this );
		controlPanel.addChangeListener( this );

		// options
		optionDisplay = new OptionDisplay(oh,ch,osp,csp,parent);
		JScrollPane optionScroll = new JScrollPane( optionDisplay );
		JScrollBar optionBar = optionScroll.getVerticalScrollBar();
		optionBar.setUnitIncrement( 10 );
		optionDisplay.addItemListener( displayPanel );
		optionDisplay.addItemListener( pathGraph );
		optionDisplay.addItemListener( this );
		optionScroll.setPreferredSize( new Dimension( 400, 150 ) );
		displayTabs.addChangeListener( optionDisplay );

		// control/options panel
		JPanel superControlPanel = new JPanel();
		superControlPanel.add( controlPanel );
		superControlPanel.add( optionScroll );
		superControlPanel.setLayout( new BoxLayout(superControlPanel, 
					                 BoxLayout.X_AXIS) );
		controlTabs.addTab( "Display Control", superControlPanel );

		// information tab
		infoPanel = new InfoPanel(ah);
		infoPanel.setPreferredSize( new Dimension( 750, 150 ) );
		JScrollPane infoScroll = new JScrollPane( infoPanel );
		JScrollBar infoBar = infoScroll.getVerticalScrollBar();
		infoBar.setUnitIncrement( 10 );
		controlTabs.addTab("Alignment Information",infoScroll);

		// create the split
		JSplitPane split = new JSplitPane( JSplitPane.VERTICAL_SPLIT,
											displayTabs, controlTabs );
		split.setOneTouchExpandable( true );
		split.setDividerLocation( 400 );
		split.setPreferredSize( new Dimension( 800,500 ) );
		split.setBackground( Color.white );

		setLayout( new BoxLayout(this, BoxLayout.Y_AXIS) );
		add( split );


		// Now do animation stuff
		_timer = new Timer(mediumDelay,this);
		_timer.setInitialDelay(0);
		_timer.setCoalesce(true);

		// has to happen after everything has been created... 
		addActionListener( pathGraph );

	}

	public void addActionListener( ActionListener a )
	{
		controlPanel.addActionListener( a );
		_timer.addActionListener( a );
	}

	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
		setBackground(Color.white);
	}

	public synchronized void startAnimation()
	{
		if (!_timer.isRunning())
			_timer.start();
	}

	public synchronized void stopAnimation()
	{
		if (_timer.isRunning())
			_timer.stop();
	}

	public void actionPerformed(ActionEvent e)
	{
		String command = e.getActionCommand();
		//
		// null is the timer event
		//
		if ( command == null )
		{
			ah.incrementCurrent(ch);
			repaint();
		}
		//
		// all other events
		//
		else
		{
			if ( command.equals("Play") ) 
			{
				startAnimation();
			}
        	else if ( command.equals("Pause") )
			{
       			stopAnimation(); 
			}
        	else if ( command.equals("Step Forward") )
			{
				ah.incrementCurrent(ch);
				repaint();
       			stopAnimation(); 
			}
        	else if ( command.equals("Step Backward") )
			{
				ah.decrementCurrent(ch);
				repaint();
       			stopAnimation(); 
			}
			else if ( command.equals("Location") )
        	{
           		JTextField textSource = (JTextField)e.getSource();
            	String numberString = textSource.getText().trim();
            	int newLocation = 0;
            	try
            	{
               		newLocation = Integer.parseInt(numberString);
            	}
            	catch (NumberFormatException ne)
            	{
               		System.out.println("Ignoring ERROR:  SeqComparePanel " + 
							           "invalid integer: " + numberString);
            	}
 
            	ah.setCurrent(newLocation);
				repaint();
        	}
			else if ( command.equals("Slow") )
				_timer.setDelay(slowDelay);
			else if ( command.equals("Medium") )
				_timer.setDelay(mediumDelay);
			else if ( command.equals("Fast") )
				_timer.setDelay(fastDelay);
		}
	}


    public void stateChanged(ChangeEvent e)
    {
        Object source = e.getSource();
        if ( source instanceof JSlider )
		{
			JSlider pos = (JSlider)source;
            if ( !pos.getValueIsAdjusting() )
            {
				int fps = (int)pos.getValue();
				// We only want to set the current value if the slider
				// has changed manually.
				if ( fps != sliderPrev+1 && fps != sliderPrev-1 )
				{
					ah.setCurrent( fps );
                	repaint();
				}
				sliderPrev = fps;
            } 
		}
    }

	// Listen to the option list for item selection event and 
	// repaint if the animation is stopped.
	public void itemStateChanged(ItemEvent e)
	{
		if (!_timer.isRunning())
			repaint();
	}

	public AlignmentDisplayPanel getAlignmentDisplayPanel()
	{
		return displayPanel; 
	}

	public PathDisplay getPathDisplayPanel()
	{
		return pathGraph; 
	}
}
