
/* 
 * Copyright (C) 2002-@year@ by University of Maryland, College Park, MD 20742, USA 
 * All rights reserved. 
 * 
 * Piccolo was written at the Human-Computer Interaction Laboratory 
 * www.cs.umd.edu/hcil by Jesse Grosjean under the supervision of Ben Bederson. 
 * The Piccolo website is www.cs.umd.edu/hcil/piccolo 
 */ 
package edu.virginia.bioch.nopt.display.path;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;

import edu.umd.cs.piccolo.event.*;
import edu.umd.cs.piccolo.*;
import edu.umd.cs.piccolo.util.*;

/**
 * <b>PanHandler</b> extends the PPaneEventHandler so that only
 * horizontal panning occurs.
 * <P>
 * @author Mike Smoot based on Jesse Grosjean's code.
 */
public class PanHandler extends PPanEventHandler {
	

	protected PCamera horCam;
	protected PCamera vertCam;

	public PanHandler( PCamera hor, PCamera vert ) {
		super();
		horCam = hor;
		vertCam = vert;
	}

	protected void pan(PInputEvent e) {

		if ( e.isAltDown() )
			return;

		PCamera c = e.getCamera();

		if ( c == horCam || c == vertCam )
			return;

		Point2D l = e.getPosition();
		
		if (c.getViewBounds().contains(l)) {
			PDimension d = e.getDelta();
			c.translateView(d.getWidth(), d.getHeight());
			horCam.translateView(d.getWidth(), 0);
			vertCam.translateView( 0, d.getHeight() );
		}
	}
		
	
	/**
	 * Do auto panning	even when the mouse is not moving.
	 */
	protected void dragActivityStep(PInputEvent aEvent) {
	
		if ( aEvent.isAltDown() )
			return;

		if (!getAutopan()) 
			return;

		PCamera c = aEvent.getCamera();

		if ( c == horCam || c == vertCam )
			return;

		PBounds b = c.getBoundsReference();
		Point2D l = aEvent.getPositionRelativeTo(c);
		int outcode = b.outcode(l);
		PDimension delta = new PDimension();
		
		if ((outcode & Rectangle.OUT_TOP) != 0) {
			delta.height = validatePanningSpeed(-1.0 - (0.5 * Math.abs(l.getY() - b.getY())));
		} else if ((outcode & Rectangle.OUT_BOTTOM) != 0) {
			delta.height = validatePanningSpeed(1.0 + (0.5 * Math.abs(l.getY() - (b.getY() + b.getHeight()))));
		}
		
		if ((outcode & Rectangle.OUT_RIGHT) != 0) {
			delta.width = validatePanningSpeed(1.0 + (0.5 * Math.abs(l.getX() - (b.getX() + b.getWidth()))));
		} else if ((outcode & Rectangle.OUT_LEFT) != 0) {
			delta.width = validatePanningSpeed(-1.0 - (0.5 * Math.abs(l.getX() - b.getX())));
		}
		
		c.localToView(delta);		
		
		if (delta.width != 0 || delta.height != 0) {
			c.translateView(delta.width, delta.height);
		}

		if (delta.width != 0 )  {
			horCam.translateView(delta.width, 0 );
		}

		if (delta.height != 0 )  {
			vertCam.translateView(0, delta.height );
		}
	}
}
