
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/editor/EditAlignmentPanel.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.editor;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.lang.Thread.*;
import java.util.*;
import java.lang.Exception.*;
import java.io.IOException;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.actions.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.util.*;
import edu.virginia.bioch.nopt.*;
import edu.virginia.bioch.nopt.display.*;

import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.text.*;

public class EditAlignmentPanel extends JPanel
	implements MouseMotionListener, MouseListener
{

	protected AlignmentHandler ah; 
	protected OptionHandler oh; 
	protected StringBuffer seq1;
	protected StringBuffer seq2;
	protected Alignment currAlign;
	protected int lastX;
	protected int charWidth;
	protected char gap;
	protected int seq1Top;
	protected int seq1Bot;
	protected int seq2Top;
	protected int seq2Bot;
	protected int seq2Offset;
	protected int topOffset;
	protected int leftOffset;
	protected Font normalFont;
	protected GlyphVector gv1;
	protected GlyphVector gv2;

	public EditAlignmentPanel( AlignmentHandler ah, 
	                           FontHandler fh,
							   OptionHandler oh )
	{
		super();
		System.out.println("EditAlignmentPanel constructor");
		this.ah = ah;
		this.oh = oh;

		lastX = 0;
		charWidth = Option.getGlyphWidth();
		gap = '-';
		seq2Offset = 20;
		seq1Top = 30;
		seq1Bot = 40;
		seq2Top = seq1Top + seq2Offset;
		seq2Bot = seq1Bot + seq2Offset;
		topOffset = 10;
		leftOffset = 10;

		Color backColor = Color.white; 
		setBackground( backColor );

		setString();

		normalFont = fh.getNormalFont(); 

		addMouseMotionListener( this );
		addMouseListener( this );
	
		setPreferredSize( new Dimension( getWindowWidth() , 100));
	}

	public void setString()
	{
		
		currAlign = ah.getCurrentAlignment();
		String s1 = currAlign.getSeq1();
		String s2 = currAlign.getSeq2();
		seq1 = new StringBuffer( s1.toLowerCase() );
		seq2 = new StringBuffer( s2.toLowerCase() );
		setPreferredSize( new Dimension( getWindowWidth(), 100));
	}

	protected int getWindowWidth()
	{
		return ((Math.max(seq1.length(),seq2.length())+30)*charWidth);
	}

	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);

		Graphics2D g2 = (Graphics2D)g;

		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
		                   RenderingHints.VALUE_ANTIALIAS_ON);

		FontRenderContext frc = g2.getFontRenderContext();
				
		gv1 = normalFont.createGlyphVector(frc,seq1.toString());
		gv2 = normalFont.createGlyphVector(frc,seq2.toString());

		Alignment a = ah.getCurrentAlignment();

		int s1Count = 0;
		for ( int i = 0; i < gv1.getNumGlyphs(); i++ )
		{
			Point2D pos1 = gv1.getGlyphPosition(i);

			double xPos = i * charWidth;
			double yPos = 30.0;

			pos1.setLocation( xPos, yPos );

			gv1.setGlyphPosition(i,pos1);


			//drawHighlight( i );
			//
			if ( s1Count % 10 == 0 && seq1.charAt(i) != gap && s1Count > 0 )
			{
				AttributedString num = new AttributedString(
					Integer.toString(s1Count + a.getBegin1Index()));
				num.addAttribute(TextAttribute.FAMILY, "serif");
				num.addAttribute(TextAttribute.SIZE, new java.lang.Float(8));
				num.addAttribute(TextAttribute.FOREGROUND, Color.blue );
				g2.drawString(num.getIterator(), (int)xPos, 10);
			}

			if ( seq1.charAt(i) != gap )
				s1Count++;

		}

		int s2Count = 0;
		for ( int i = 0; i < gv2.getNumGlyphs(); i++ )
		{

            Point2D pos2 = gv2.getGlyphPosition(i);

			double xPos = i * charWidth;
			double yPos = 30.0;

			pos2.setLocation( xPos, yPos + seq2Offset );

			gv2.setGlyphPosition(i,pos2);

			if ( s2Count % 10 == 0 && seq2.charAt(i) != gap && s2Count > 0 )
			{
				AttributedString num = new AttributedString(
					Integer.toString(s2Count + a.getBegin2Index()));
				num.addAttribute(TextAttribute.FAMILY, "serif");
				num.addAttribute(TextAttribute.SIZE, new java.lang.Float(8));
				num.addAttribute(TextAttribute.FOREGROUND, Color.blue );
				g2.drawString(num.getIterator(), (int)xPos, 80 );
			}

			if ( seq2.charAt(i) != gap )
				s2Count++;
		}

		g2.drawGlyphVector( gv1, leftOffset, topOffset );
		g2.drawGlyphVector( gv2, leftOffset, topOffset );

	}

	public void mouseReleased(MouseEvent e) { }
	public void mouseClicked(MouseEvent e) { }
	public void mouseEntered(MouseEvent e) { }
	public void mouseExited(MouseEvent e) { }
	public void mouseMoved(MouseEvent e) { }

	public void mousePressed(MouseEvent e)
	{
		lastX = e.getX();
	}

	public void mouseDragged(MouseEvent e)
	{
		int x = e.getX();
		int diff = x - lastX;

		if ( diff > 0 && diff > charWidth )
		{
			rightDrag( e.getPoint() );
			lastX = x;
		}

		else if ( diff < 0 && Math.abs(diff) > charWidth )
		{
			leftDrag( e.getPoint() );
			lastX = x;
		}
	}

	//   <<<<---------
	private void leftDrag( Point p )
	{
		int y = (int)p.getY();	
		int x = (int)p.getX();	
		x -= leftOffset;
		float z = (float)x/(float)charWidth;
		x = (int)z;
		if ( y >= seq1Top && y <= seq1Bot )
		{
			if ( x > 1 && x < seq1.length() && seq1.charAt(x) == gap )
			{
				seq1.deleteCharAt(x);
				repaint();
			}	
		}
		else if ( y >= seq2Top && y <= seq2Bot )
		{
			if ( x > 1 && x < seq2.length() && seq2.charAt(x) == gap )
			{
				seq2.deleteCharAt(x);
				repaint();
			}
		}
	}

	//   --------->>>>
	private void rightDrag( Point p )
	{
		int y = (int)p.getY();	
		int x = (int)p.getX();	
		x -= leftOffset;
		float z = (float)x/(float)charWidth;
		x = (int)z;
		x -= 1;
		if ( y >= seq1Top && y <= seq1Bot )
		{
			if ( x >= 0 ) 
			{
				if ( x > seq1.length() )
					x = seq1.length();

				seq1.insert(x,gap);
				repaint();
			}
		}
		else if ( y >= seq2Top && y <= seq2Bot )
		{
			if ( x >= 0 ) 
			{
				if ( x > seq2.length() )
					x = seq2.length();

				seq2.insert(x,gap);
				repaint();
			}
		}
	}

	public boolean process()
	{
		if ( isSane() )
		{
			int bi1 = currAlign.getBegin1Index();	
			int bi2 = currAlign.getBegin2Index();	
			int ei1 = currAlign.getEnd1Index();	
			int ei2 = currAlign.getEnd2Index();	
			String pk = currAlign.getParamKey();
			Alignment newAlign = new Alignment( ah, seq1.toString(), 
											seq2.toString(), pk, 
											bi1, bi2, ei1, ei2 ) ;
			ah.addAlignment( newAlign );
			oh.initializeOptions();
			return true;
		}

		return false;
	}			

	private boolean isSane()
	{
		// make sure seqs are the same length
		if ( seq1.length() != seq2.length() )
		{
			JOptionPane.showMessageDialog( this,
                       "The new sequences aren't the same length!\n" +
					   "You must add/delete the same number of gaps from\n" +
					   "each sequence.\nNOT adding alignment!",
                        "Edit failure", JOptionPane.ERROR_MESSAGE );
			return false;
		}
	
		// Check to see if gaps are in both locations.  If so remove them.
		char gap = '-';
		String positions = "";
		for ( int i = 0; i < seq1.length(); i++ )
			if ( seq1.charAt(i) == gap && seq2.charAt(i) == gap )
			{
				positions += Integer.toString(i) + ",";
				seq1.deleteCharAt(i);
				seq2.deleteCharAt(i);
				i--;  // recheck current pos once we've deleted
			}

		if ( !positions.equals("") )
			JOptionPane.showMessageDialog( this,
				"Gaps found in both sequences at position(s): " +
				positions + "\nDeleting from sequences.",
				"Edit problem", JOptionPane.PLAIN_MESSAGE );

		// if we've gotten to this point, the we're sane...
		return true;
	}
}
