
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/OptionCreatorPanel.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 


package edu.virginia.bioch.nopt.options;



import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.lang.Thread.*;
import java.util.*;
import java.lang.Exception.*;
import java.io.IOException;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.styles.*;
import edu.virginia.bioch.util.*;


import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;

public class OptionCreatorPanel extends JPanel
{
	protected JTextField nameText; 
	protected JTextField beginText;
	protected JTextField endText;
	protected JButton addButton;

	public OptionCreatorPanel( )
	{
		Color backColor = Color.white; 
		setBackground( backColor );
		setLayout( new BoxLayout( this, BoxLayout.Y_AXIS ) );
		
		JPanel boxes = new JPanel(); // FlowLayout
		boxes.setBackground( backColor );

		JLabel nameLabel = new JLabel("Name");
		nameText = new JTextField(40); 
		JPanel namePanel = new JPanel();
		namePanel.add( nameLabel );
		namePanel.add( nameText );
		namePanel.setLayout( new BoxLayout( namePanel, BoxLayout.Y_AXIS ) );
		namePanel.setBackground( backColor );
		boxes.add( namePanel );

		JLabel beginLabel = new JLabel("Begin");
		beginText = new JTextField(5); 
		JPanel beginPanel = new JPanel();
		beginPanel.add( beginLabel );
		beginPanel.add( beginText );
		beginPanel.setLayout( new BoxLayout( beginPanel, BoxLayout.Y_AXIS ) );
		beginPanel.setBackground( backColor );
		boxes.add( beginPanel );

		JLabel endLabel = new JLabel("End");
		endText = new JTextField(5); 
		JPanel endPanel = new JPanel();
		endPanel.add( endLabel );
		endPanel.add( endText );
		endPanel.setLayout( new BoxLayout( endPanel, BoxLayout.Y_AXIS ) );
		endPanel.setBackground( backColor );
		boxes.add( endPanel );

		add( boxes );

		addButton = new JButton( "Add to List" );
		addButton.setActionCommand("add new option to list");
		add( addButton );

		setBorder( BorderFactory.createTitledBorder("Create an Annotation") );
	}

	public void addActionListener( ActionListener a )
	{
		addButton.addActionListener(a);
	}

	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
	}

	public String getNameString()
		throws Exception
	{
		String nt = nameText.getText();

		if ( nt.equals("") )
			throw new Exception( "Name is blank!" );

		return nt;
	}

	public int getNumber( JTextField field )
		throws Exception
	{
		int i = 0;

		try { 

		i = Integer.parseInt( field.getText() );

		} catch (NumberFormatException e) 
		{
			e.printStackTrace();
			String mess = "Failed to parse number entered!\n" + e.getMessage();
			throw new Exception( mess );
		}

		return i;
	}

	public String getRange()
		throws Exception
	{
		int begin = getNumber( beginText );
		int end = getNumber( endText );

		while ( begin > end )
		{
			int tmp = begin;
			begin = end;
			end = tmp;

			if ( begin < 0 ) 
				begin = 0;
		}
			
		return Integer.toString( begin ) + "-" + Integer.toString( end );
	}


	public void clear()	
	{
		// clear the boxes
		nameText.setText("");
		beginText.setText("");
		endText.setText("");
	}
}
