
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/OptionKey.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.options;

import java.lang.*;
import java.util.*;

public class OptionKey
	implements Comparable
{
	protected String seqName; 
	protected String feature;
	protected String source;

	private int hashCode;

	public OptionKey()
	{ 
		set("","","");
	}

	public OptionKey ( String n, String f, String s )
	{
		set(n,f,s);
	}

	public void set ( String n, String f, String s )
	{
		seqName = n;
		feature = f;
		source = s;

		String tmp = seqName + feature + source; 
				   
		hashCode = tmp.hashCode();
	}

	public String getSeqName()
	{ return seqName; }

	public String getFeature()
	{ return feature; }

	public String getSource()
	{ return source; }

	public String getGFFSeqName()
	{ return seqName.replace(' ','~'); }

	public String getGFFFeature()
	{ return feature.replace(' ','~'); }

	public String getGFFSource()
	{ return source.replace(' ','~'); }

	public boolean equals( Object ek )
	{
		if ( this == ek )
			return true;

		if ( ek instanceof OptionKey )
		{
			if ( ((OptionKey)ek).getSeqName().equals( seqName ) &&
			     ((OptionKey)ek).getFeature().equals( feature ) &&
			     ((OptionKey)ek).getSource().equals( source ) ) 
				return true;
			else
				return false;
		}
		else
			return false;
	}

	public int hashCode()
	{ return hashCode; }


	public String toString()
	{
		return ( seqName + " - " + feature + " (" + source + ")" );
	}

	public Object clone()
	{
		return new OptionKey( seqName, feature, source );
	}

	public int compareTo( Object o )
	{
		if ( this == o )
			return 0;

		if ( o instanceof OptionKey )
			return ( (toString()).compareTo( ((OptionKey)o).toString() ) );
		else 
			throw new ClassCastException("Attempting to compare different " +
					                     "kinds of objects" );
	}
		
}

