
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/OptionSetReader.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.options;



import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.lang.Thread.*;
import java.util.Vector;
import java.lang.Exception.*;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.styles.*;
import edu.virginia.bioch.util.*;
import edu.virginia.bioch.scoringmatrices.*;


import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.text.*;
import java.util.*;
import java.io.*;
import java.net.*;

import org.biojava.bio.program.gff.*;
import org.biojava.bio.*;
import org.biojava.utils.*;

public class OptionSetReader 
{
	protected TreeMap optionMap;
	protected String seqName;

	public OptionSetReader( BufferedReader input ) 
		throws Exception
	{
		System.out.println("OptionSetReader constructor (boolean,String)");
		seqName = "";

		optionMap = new TreeMap();

		if ( input != null )
			readGFF( input );

	}

	public OptionSetReader( File name, String sn )
		throws Exception
	{
		System.out.println("OptionSetReader constructor (File)");
		seqName = sn;

		optionMap = new TreeMap();

		try {
	
		BufferedReader input = new BufferedReader( new FileReader(name) );
		readGFF( input );

		}
		catch ( IOException e )           { fileFailure(e); }
	}

	private void readGFF( BufferedReader input )
		throws Exception
	{

		try {

		GFFEntrySet es = GFFTools.readGFF(input);
		Iterator git = es.lineIterator();
		while( git.hasNext() )
		{
			Object o = git.next();
			if ( o instanceof GFFRecord ) 
			{
				GFFRecord rec = (GFFRecord)o;

				String name = "";
				if ( seqName.equals("") )
					name = rec.getSeqName();
				else
					name = seqName;

				OptionKey key = new OptionKey(
						                 name.replace('~',' '), 
				                         rec.getFeature().replace('~',' '),
							             rec.getSource().replace('~',' ') ); 

				int begin = rec.getStart();
				int end = rec.getEnd();
				String range = Integer.toString(begin) + "-" + 
				               Integer.toString(end);

				if ( optionMap.containsKey( key ) )
				{
					String r = (String)(optionMap.get(key));
					r = r + "," + range;
					optionMap.put(key, r);
				}
				else
					optionMap.put( key, range );

			}
		}

		} 
		catch (ParserException  e)           { gffFailure(e); }
		catch (BioException  e)              { gffFailure(e); }
		catch (IOException  e)               { gffFailure(e); }
		catch (IndexOutOfBoundsException  e) { gffFailure(e); }
	}

	private void gffFailure(Exception e)
		throws Exception
	{
		optionMap.clear();

		e.printStackTrace(); 
		String mess = "ERROR: Failed to parse GFF file.\n" +
		              "Are you sure its formatted properly?\n" + 
		              "Specified file not loaded.\n" + e.getMessage();

		throw( new Exception(mess) );
	}

	private void fileFailure(Exception e)
		throws Exception
	{
		optionMap.clear();

		e.printStackTrace(); 
		String mess = "ERROR: Failed to open specified annotation file.\n" + 
				      e.getMessage();

		throw( new Exception(mess) );
	}

	public Map getOptionMap() { return optionMap; }
}      

