
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/OptionTable.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 


package edu.virginia.bioch.nopt.options;



import java.lang.*;
import java.io.*;
import java.util.*;
import java.awt.event.*;
import java.awt.*;
import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;
import java.awt.geom.Rectangle2D.*;
import java.awt.geom.Line2D.*;
import javax.swing.event.*;
import javax.swing.*;
import javax.swing.table.*;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.nopt.options.styles.*;
import edu.virginia.bioch.util.*;


public class OptionTable
	extends JTable
{
	protected TableCellRenderer unselectedRenderer;
	protected OptionTableModel otm;  // need this in lieu of dataModel

	public OptionTable( OptionTableModel otm, TableCellRenderer us )
	{
		super(otm);
		unselectedRenderer = us;
		this.otm = otm;
	}

	public TableCellRenderer getCellRenderer(int row, int column) 
	{
		if ( column == 1 && 
		     (otm.getValueAt(row,1)).equals( otm.getUnselectedSeq() ) )
			return unselectedRenderer;

		if ( column == 2 &&
				(otm.getValueAt(row,2)).equals( otm.getUnselectedType() ) )
			return unselectedRenderer;

		//if ( column == 0 &&
	//			  !((Boolean)(otm.getValueAt(row,0))).booleanValue() )
	//		return unselectedRenderer;
		
		return super.getCellRenderer(row, column);
	}	
}

