
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/styles/IdentityOption.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.options.styles;


import java.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.Font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;
import java.awt.geom.Rectangle2D.*;
import java.awt.geom.Line2D.*;
import java.lang.*;
import java.net.*;
import java.text.*;
import java.util.*;
import java.util.Vector;
import javax.swing.*;
import javax.swing.event.*;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.util.*;


public class IdentityOption extends Option
{
	protected Rectangle2D.Double r1;
	protected Color origColor;

	public static String getTitle() { return "Identity Option" ; }	
	public static ImageIcon getIcon()
	{
		return Option.createIcon("images/IdentityOption.icon.png", 
				                 "Identity Option"); 
	}


	public IdentityOption( AlignmentHandler ah )
	{
		super("Identity Highlight","", Option._bothId, "IDENTITY", ah,
			  "Highlight identical characters.");
		System.out.println("IdentityOption constructor");
		
		r1 = new Rectangle2D.Double( 0,
					                 _descent + _separation/2 ,
								     _glyphWidth, 
								     _separation/2 );
	}

	public void addKey( EdgeKey key )
   	{
		if ( !_edgesToDraw.containsKey( key ) )
	    {            
			char char1 = key.getTopChar();
			char char2 = key.getBotChar();

			if ( char1 == char2 && char1 != '-' && char2 != '-' )
				_edgesToDraw.put( key, new Boolean( true ) );
			else
				_edgesToDraw.put( key, new Boolean( false ) );
				
		}
	}


	public void draw(EdgeKey key, int i, double xPos, double yPos, Graphics2D g,
                     String char1, String char2, int s1Count, int s2Count)
	{
		if ( ((Boolean)_edgesToDraw.get( key )).booleanValue() && _on )
		{
			origColor = g.getColor();

			g.setColor( Color.red );
			g.fill(r1);

			g.setColor( origColor );
        }
	}
}


