
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/styles/NumberOption.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.options.styles;


import java.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;
import java.awt.geom.Rectangle2D.*;
import java.awt.geom.Line2D.*;
import java.lang.*;
import java.net.*;
import java.text.*;
import java.util.*;
import java.util.Vector;
import javax.swing.*;
import javax.swing.event.*;
import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.util.*;


public class NumberOption extends Option
{
	protected HashMap _bottomEdgesToDraw;

	public static String getTitle() { return "Number Option" ; }	
	public static ImageIcon getIcon()
	{
		return Option.createIcon("images/NumberOption.icon.png", 
				                 "Number Option"); 
	}

	public NumberOption( AlignmentHandler ah )
	{
		super("Numbers","",Option._bothId, "NUMBERS", ah,
			  "Number the sequences." );

		System.out.println("NumberOption constructor");

		_bottomEdgesToDraw = new HashMap();
	}

	public void addKey( EdgeKey key )
	{
		if ( !_edgesToDraw.containsKey( key ) )
        {
			String char1 = key.getTopCharString();
			String char2 = key.getBotCharString();

			int x = key.getEndX();
			int y = key.getEndY();

			if ( x % 10 == 0 && !char1.equals(gap) )
				_edgesToDraw.put( key, new Boolean( true ) );
			else
				_edgesToDraw.put( key, new Boolean( false ) );

			if ( y % 10 == 0 && !char2.equals(gap) )
				_bottomEdgesToDraw.put( key, new Boolean( true ) );
			else
				_bottomEdgesToDraw.put( key, new Boolean( false ) );
		}
	}

	public void draw(EdgeKey key, int i, double xPos, double yPos, Graphics2D g,
                     String char1, String char2, int s1Count, int s2Count)
	{

		if ( ((Boolean)_edgesToDraw.get( key )).booleanValue() && _on )
        {
			Alignment al = _ah.getCurrentAlignment();
            AttributedString num = new AttributedString(
            	Integer.toString(s1Count + al.getBegin1Index())); 
            num.addAttribute(TextAttribute.FAMILY, smallFontName);
            num.addAttribute(TextAttribute.SIZE,
								new java.lang.Float(smallFontSize));            
			num.addAttribute(TextAttribute.FOREGROUND, Color.blue );
            g.drawString(num.getIterator(), 0, 0-_ascent);
        }

		if ( ((Boolean)_bottomEdgesToDraw.get( key )).booleanValue() && _on )
        {
			Alignment al = _ah.getCurrentAlignment();
            AttributedString num = new AttributedString(
           		Integer.toString(s2Count + al.getBegin2Index())); 
            num.addAttribute(TextAttribute.FAMILY, smallFontName);
            num.addAttribute(TextAttribute.SIZE,
								new java.lang.Float(smallFontSize));            
			num.addAttribute(TextAttribute.FOREGROUND, Color.blue );
            g.drawString(num.getIterator(), 0,
							      0 + _descent + _separation + _ascent +
								      _descent + _smallAscent);
        }
	}
}

