
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/styles/SquareOption.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.options.styles;

import java.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.Font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;
import java.awt.geom.Rectangle2D.*;
import java.awt.geom.Line2D.*;
import java.lang.*;
import java.net.*;
import java.text.*;
import java.util.*;
import java.util.Vector;
import javax.swing.*;
import javax.swing.event.*;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.util.*;



public class SquareOption extends Option
{
	protected Color displayColor;
	protected Color origColor;
	protected Color matchColor;
	protected Rectangle2D.Double topRect;
	protected Rectangle2D.Double botRect;

	public static String getTitle() { return "Square Option" ; }
	public static ImageIcon getIcon()
	{
		return Option.createIcon("images/SquareOption.icon.png", 
				                 "Square Option"); 
	}

	public SquareOption(String n, String rs, String app, AlignmentHandler ah,
			            String d) 
    {
		super( n, rs, app, "Square", ah, d );
		System.out.println("SquareOption constructor");

		//
		// Note that the middle point of QuadCurve2D is calculated 
		// by the function. So the middle point specified here is 
		// really only the direction the fuction should head, not where 
		// the middle of the curve will actually fall. For these
		// functions the value of _descent is what we offset the 
		// middle value by to get the proper location and shape.
		//


		matchColor = new Color( 1.0f,0.90f,0.1f); // dark yellow

		topRect = new Rectangle2D.Double( 0, _descent, 
										_glyphWidth, _separation/2 );

		botRect = new Rectangle2D.Double( 0, _descent + _separation/2, 
										_glyphWidth, _separation/2 );

	}

	public void draw(EdgeKey key, int i, double xPos, double yPos, Graphics2D g,
	                 String c1, String c2, int count1, int count2)
	{
		if ( ((Boolean)_edgesToDraw.get( key )).booleanValue() && _on )
		{
			displayColor = Color.lightGray;

			if ( ((Boolean)_conditionalEdges.get( key )).booleanValue() &&
					_conditionalCount > 1 )
				displayColor = matchColor; 

			origColor = g.getColor();
			g.setColor(displayColor);

			if ( _applicableSeq.equals(Option._seq1Id) ) 
			{
				g.fill(topRect);
				g.draw(topRect);
			}

			if ( _applicableSeq.equals(Option._seq2Id) ) 
			{
				g.fill(botRect);
				g.draw(botRect);
			}

			g.setColor(origColor);
		}
	}

	// Note that the conditionalCount stuff must be local to this class,
	// we can generalize and put it in Option because the count is specific
	// to this class.
	static int _conditionalCount;

	static
	{
		_conditionalCount = 0;
	}

	public void turnOff()
	{
		super.turnOff();
		_conditionalCount--;
	}

	public void turnOn()
	{
		super.turnOn();
		_conditionalCount++;
	}
}
