
/*
 * 
 *  file:  ./src/edu/virginia/bioch/nopt/options/styles/TriangleOption.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.options.styles;

import java.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.Font.*;
import java.awt.Font.*;
import java.awt.Graphics2D.*;
import java.awt.geom.*;
import java.awt.geom.Point2D.*;
import java.awt.geom.Rectangle2D.*;
import java.awt.geom.Line2D.*;
import java.lang.*;
import java.net.*;
import java.text.*;
import java.util.*;
import java.util.Vector;
import javax.swing.*;
import javax.swing.event.*;

import edu.virginia.bioch.nopt.display.*;
import edu.virginia.bioch.nopt.alignments.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.util.*;



public class TriangleOption extends Option
{
	protected Color displayColor;
	protected Color origColor;
	protected Color matchColor;
	protected GeneralPath topTri; 
	protected GeneralPath botTri;

	public static String getTitle() { return "Triangle Option" ; }
	public static ImageIcon getIcon()
	{
		return Option.createIcon("images/TriangleOption.icon.png", 
				                 "Triangle Option"); 
	}

	public TriangleOption(String n, String rs, String app, AlignmentHandler ah,
			              String d ) 
    {
		super( n, rs, app, "TRIANGLE", ah, d );
		System.out.println("TriangleOption constructor");

		//
		// Note that the middle point of QuadCurve2D is calculated 
		// by the function. So the middle point specified here is 
		// really only the direction the fuction should head, not where 
		// the middle of the curve will actually fall. For these
		// functions the value of _descent is what we offset the 
		// middle value by to get the proper location and shape.
		//

		topTri = new GeneralPath();
		topTri.moveTo((float)(_glyphWidth*0.5), 0.0f + _descent/2 );
		topTri.lineTo((float)_glyphWidth, _descent + _separation/2 );
		topTri.lineTo(0f, _descent + _separation/2 );
		topTri.lineTo((float)(_glyphWidth*0.5), 0.0f  + _descent/2);

		botTri = new GeneralPath();
		botTri.moveTo((float)(_glyphWidth*0.5), _descent + _separation + _descent/2);
		botTri.lineTo((float)_glyphWidth, _descent + _separation/2 );
		botTri.lineTo(0f, _descent + _separation/2 );
		botTri.lineTo((float)(_glyphWidth*0.5), _descent + _separation+ _descent/2);

		matchColor = new Color(0.1f,0.5f,0.7f); // ?? 

	}

	public void draw(EdgeKey key, int i, double xPos, double yPos, Graphics2D g,
	                 String c1, String c2, int count1, int count2)
	{
		if ( ((Boolean)_edgesToDraw.get( key )).booleanValue() && _on )
		{
			displayColor = Color.lightGray;

			if ( ((Boolean)_conditionalEdges.get( key )).booleanValue() &&
					_conditionalCount > 1 )
				displayColor = matchColor; 

			origColor = g.getColor();
			g.setColor(displayColor);

			if ( _applicableSeq.equals( Option._seq1Id) ) 
			{
				g.fill(topTri);
				g.draw(topTri);
			}

			if ( _applicableSeq.equals(Option._seq2Id) ) 
			{
				g.fill(botTri);
				g.draw(botTri);
			}

			g.setColor(origColor);
		}
	}

	// Note that the conditionalCount stuff must be local to this class,
	// we can generalize and put it in Option because the count is specific
	// to this class.
	static int _conditionalCount;

	static
	{
		_conditionalCount = 0;
	}

	public void turnOff()
	{
		super.turnOff();
		_conditionalCount--;
	}

	public void turnOn()
	{
		super.turnOn();
		_conditionalCount++;
	}
}
