
/*
 * 
 *  file:  ./src/edu/virginia/bioch/scoringmatrices/DnaMatrices.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.scoringmatrices;
//===================================================================
//
// Scoring Matrices delivered with BLAST and Java-ized.
//
//===================================================================


import java.lang.*;

interface DnaMatrices
{

	//
	// This matrix was created by Todd Lowe   12/10/92
	//
	// Uses ambiguous nucleotide codes, probabilities rounded to
	//  nearest integer
	//
	// Lowest score = -4, Highest score = 5
	//
	/*
	public final String nuc_4.2_Alphabet = "ATGC";
	public final int[] nuc_4.2 =  { 
	 5,
	-4, 5,
	-4,-4, 5,
	-4,-4,-4, 5
	-4,-4, 1, 1
	 1, 1,-4,-4
	 1,-4, 1,-4
	-4, 1,-4, 1
	-4, 1, 1,-4
	 1,-4,-4, 1
	-4,-1,-1,-1
	-1,-4,-1,-1
	-1,-1,-4,-1
	-1,-1,-1,-4
	-2,-2,-2,-2
	};
	*/

	//
	// This matrix was created by Todd Lowe   12/10/92
	//
	// Uses ambiguous nucleotide codes, probabilities rounded to
	//  nearest integer
	//
	// Lowest score = -4, Highest score = 5
	//
	public final String nuc_4_4_Alphabet = "ATGCSWRYKMBVHDN";
	public final int[] nuc_4_4 =  { 
	 5,
	-4, 5,
	-4,-4, 5,
	-4,-4,-4, 5,
	-4,-4, 1, 1,-1,
	 1, 1,-4,-4,-4,-1,
	 1,-4, 1,-4,-2,-2,-1,
	-4, 1,-4, 1,-2,-2,-4,-1,
	-4, 1, 1,-4,-2,-2,-2,-2,-1,
	 1,-4,-4, 1,-2,-2,-2,-2,-4,-1,
	-4,-1,-1,-1,-1,-3,-3,-1,-1,-3,-1,
	-1,-4,-1,-1,-1,-3,-1,-3,-3,-1,-2,-1,
	-1,-1,-4,-1,-3,-1,-3,-1,-3,-1,-2,-2,-1,
	-1,-1,-1,-4,-3,-1,-1,-3,-1,-3,-2,-2,-2,-1,
	-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
	};
}
