
/*
 * 
 *  file:  ./src/edu/virginia/bioch/scoringmatrices/PamMatrices2.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.scoringmatrices;

//===================================================================
//
// Scoring Matrices delivered with BLAST and Java-ized.
//
//===================================================================


import java.lang.*;

interface PamMatrices2
{

	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 10 substitution matrix, scale = ln(2)/2 = 0.346574
	//
	// Expected score = -8.27, Entropy = 3.43 bits
	//
	// Lowest score = -23, Highest score = 13
	//
	public final String pam10_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam10 =  { 
	 7,
	-10, 9,
	-7,-9, 9,
	-6,-17,-1, 8,
	-10,-11,-17,-21, 10,
	-7,-4,-7,-6,-20, 9,
	-5,-15,-5, 0,-20,-1, 8,
	-4,-13,-6,-6,-13,-10,-7, 7,
	-11,-4,-2,-7,-10,-2,-9,-13, 10,
	-8,-8,-8,-11,-9,-11,-8,-17,-13, 9,
	-9,-12,-10,-19,-21,-8,-13,-14,-9,-4, 7,
	-10,-2,-4,-8,-20,-6,-7,-10,-10,-9,-11, 7,
	-8,-7,-15,-17,-20,-7,-10,-12,-17,-3,-2,-4, 12,
	-12,-12,-12,-21,-19,-19,-20,-12,-9,-5,-5,-20,-7, 9,
	-4,-7,-9,-12,-11,-6,-9,-10,-7,-12,-10,-10,-11,-13, 8,
	-3,-6,-2,-7,-6,-8,-7,-4,-9,-10,-12,-7,-8,-9,-4, 7,
	-3,-10,-5,-8,-11,-9,-9,-10,-11,-5,-10,-6,-7,-12,-7,-2, 8,
	-20,-5,-11,-21,-22,-19,-23,-21,-10,-20,-9,-18,-19,-7,-20,-8,-19, 13,
	-11,-14,-7,-17,-7,-18,-11,-20,-6,-9,-10,-12,-17,-1,-20,-10,-9,-8, 10,
	-5,-11,-12,-11,-9,-10,-10,-9,-9,-1,-5,-13,-4,-12,-9,-10,-6,-22,-10, 8,
	-6,-11, 7, 7,-18,-6,-1,-6,-4,-9,-12,-5,-16,-14,-10,-4,-6,-13,-9,-11, 7,
	-6,-7,-6,-1,-20, 7, 7,-8,-4,-9,-10,-6,-8,-20,-7,-8,-9,-21,-13,-10,-3, 7,
	-6,-9,-6,-9,-13,-8,-8,-8,-8,-8,-9,-8,-9,-12,-8,-6,-7,-16,-11,-8,-8,-8,-8,
	-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23,-23, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 100 substitution matrix, scale = ln(2)/2 = 0.346574
	//
	// Expected score = -1.99, Entropy = 1.18 bits
	//
	// Lowest score = -9, Highest score = 12
	//
	public final String pam100_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam100 =  { 
	 4,
	-3, 7,
	-1,-2, 5,
	-1,-4, 3, 5,
	-3,-5,-5,-7, 9,
	-2, 1,-1, 0,-8, 6,
	 0,-3, 1, 4,-8, 2, 5,
	 1,-5,-1,-1,-5,-3,-1, 5,
	-3, 1, 2,-1,-4, 3,-1,-4, 7,
	-2,-3,-3,-4,-3,-4,-3,-5,-4, 6,
	-3,-5,-4,-6,-8,-2,-5,-6,-3, 1, 6,
	-3, 2, 1,-1,-8, 0,-1,-3,-2,-3,-4, 5,
	-2,-1,-4,-5,-7,-2,-4,-4,-4, 1, 3, 0, 9,
	-5,-6,-5,-8,-7,-7,-8,-6,-3, 0, 0,-7,-1, 8,
	 1,-1,-2,-3,-4,-1,-2,-2,-1,-4,-4,-3,-4,-6, 7,
	 1,-1, 1,-1,-1,-2,-1, 0,-2,-3,-4,-1,-3,-4, 0, 4,
	 1,-3, 0,-2,-4,-2,-2,-2,-3, 0,-3,-1,-1,-5,-1, 2, 5,
	-7, 1,-5,-9,-9,-7,-9,-9,-4,-7,-3,-6,-6,-1,-7,-3,-7, 12,
	-4,-6,-2,-6,-1,-6,-5,-7,-1,-3,-3,-6,-5, 4,-7,-4,-4,-2, 9,
	 0,-4,-3,-4,-3,-3,-3,-3,-3, 3, 0,-4, 1,-3,-3,-2, 0,-9,-4, 5,
	-1,-3, 4, 4,-6, 0, 3,-1, 1,-3,-5, 0,-4,-6,-3, 0,-1,-6,-4,-4, 4,
	-1,-1, 0, 3,-8, 5, 4,-2, 1,-3,-4,-1,-2,-7,-1,-2,-2,-8,-6,-3, 2, 5,
	-1,-2,-1,-2,-5,-2,-2,-2,-2,-2,-3,-2,-2,-4,-2,-1,-1,-6,-4,-2,-2,-2,-2,
	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 110 substitution matrix, scale = ln(2)/2 = 0.346574
	//
	// Expected score = -1.81, Entropy = 1.07 bits
	//
	// Lowest score = -9, Highest score = 12
	//
	public final String pam110_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam110 =  { 
	 3,
	-3, 7,
	-1,-1, 4,
	-1,-4, 2, 5,
	-3,-4,-5,-7, 9,
	-1, 1, 0, 1,-7, 6,
	 0,-3, 1, 4,-7, 2, 5,
	 1,-4, 0, 0,-5,-3,-1, 5,
	-3, 1, 2, 0,-4, 3,-1,-4, 7,
	-1,-3,-2,-3,-3,-3,-3,-4,-4, 6,
	-3,-4,-4,-6,-8,-2,-5,-6,-3, 1, 6,
	-3, 2, 1,-1,-7, 0,-1,-3,-2,-3,-4, 5,
	-2,-1,-3,-5,-7,-1,-3,-4,-4, 1, 3, 0, 8,
	-4,-5,-4,-7,-6,-6,-7,-5,-3, 0, 0,-7,-1, 8,
	 1,-1,-2,-3,-4, 0,-2,-2,-1,-4,-4,-3,-4,-6, 6,
	 1,-1, 1,-1,-1,-2,-1, 0,-2,-3,-4,-1,-2,-4, 0, 3,
	 1,-2, 0,-1,-3,-2,-2,-2,-3, 0,-3,-1,-1,-4,-1, 2, 5,
	-7, 1,-5,-8,-9,-6,-9,-8,-4,-7,-3,-5,-6,-1,-7,-3,-6, 12,
	-4,-5,-2,-5,-1,-6,-5,-7,-1,-2,-3,-5,-5, 4,-7,-3,-3,-2, 8,
	 0,-4,-3,-4,-3,-3,-3,-2,-3, 3, 1,-4, 1,-3,-2,-2, 0,-8,-4, 5,
	-1,-2, 3, 4,-6, 0, 3, 0, 1,-3,-5, 0,-4,-6,-2, 0,-1,-6,-3,-3, 4,
	-1,-1, 0, 3,-7, 4, 4,-2, 1,-3,-3,-1,-2,-7,-1,-1,-2,-7,-5,-3, 2, 4,
	-1,-2,-1,-2,-4,-1,-2,-2,-2,-2,-2,-2,-2,-4,-2,-1,-1,-5,-3,-2,-1,-2,-2,
	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 120 substitution matrix, scale = ln(2)/2 = 0.346574
	//
	// Expected score = -1.64, Entropy = 0.979 bits
	//
	// Lowest score = -8, Highest score = 12
	//
	public final String pam120_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam120 =  { 
	 3,
	-3, 6,
	-1,-1, 4,
	 0,-3, 2, 5,
	-3,-4,-5,-7, 9,
	-1, 1, 0, 1,-7, 6,
	 0,-3, 1, 3,-7, 2, 5,
	 1,-4, 0, 0,-4,-3,-1, 5,
	-3, 1, 2, 0,-4, 3,-1,-4, 7,
	-1,-2,-2,-3,-3,-3,-3,-4,-4, 6,
	-3,-4,-4,-5,-7,-2,-4,-5,-3, 1, 5,
	-2, 2, 1,-1,-7, 0,-1,-3,-2,-3,-4, 5,
	-2,-1,-3,-4,-6,-1,-3,-4,-4, 1, 3, 0, 8,
	-4,-5,-4,-7,-6,-6,-7,-5,-3, 0, 0,-7,-1, 8,
	 1,-1,-2,-3,-4, 0,-2,-2,-1,-3,-3,-2,-3,-5, 6,
	 1,-1, 1, 0, 0,-2,-1, 1,-2,-2,-4,-1,-2,-3, 1, 3,
	 1,-2, 0,-1,-3,-2,-2,-1,-3, 0,-3,-1,-1,-4,-1, 2, 4,
	-7, 1,-4,-8,-8,-6,-8,-8,-3,-6,-3,-5,-6,-1,-7,-2,-6, 12,
	-4,-5,-2,-5,-1,-5,-5,-6,-1,-2,-2,-5,-4, 4,-6,-3,-3,-2, 8,
	 0,-3,-3,-3,-3,-3,-3,-2,-3, 3, 1,-4, 1,-3,-2,-2, 0,-8,-3, 5,
	 0,-2, 3, 4,-6, 0, 3, 0, 1,-3,-4, 0,-4,-5,-2, 0, 0,-6,-3,-3, 4,
	-1,-1, 0, 3,-7, 4, 4,-2, 1,-3,-3,-1,-2,-6,-1,-1,-2,-7,-5,-3, 2, 4,
	-1,-2,-1,-2,-4,-1,-1,-2,-2,-1,-2,-2,-2,-3,-2,-1,-1,-5,-3,-1,-1,-1,-2,
	-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 130 substitution matrix, scale = ln(2)/2 = 0.346574
	//
	// Expected score = -1.48, Entropy = 0.895 bits
	//
	// Lowest score = -8, Highest score = 12
	//
	public final String pam130_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam130 =  { 
	 3,
	-3, 6,
	 0,-1, 4,
	 0,-3, 2, 5,
	-3,-4,-4,-6, 9,
	-1, 1, 0, 1,-6, 5,
	 0,-3, 1, 3,-6, 2, 5,
	 1,-4, 0, 0,-4,-2,-1, 5,
	-2, 1, 2, 0,-4, 3, 0,-3, 7,
	-1,-2,-2,-3,-3,-3,-2,-4,-3, 5,
	-3,-4,-3,-5,-7,-2,-4,-5,-3, 1, 5,
	-2, 2, 1,-1,-6, 0,-1,-3,-1,-2,-4, 5,
	-2,-1,-3,-4,-6,-1,-3,-4,-3, 2, 3, 0, 8,
	-4,-5,-4,-7,-5,-6,-6,-5,-2, 0, 1,-6,-1, 7,
	 1,-1,-1,-2,-3, 0,-2,-2,-1,-3,-3,-2,-3,-5, 6,
	 1,-1, 1, 0, 0,-1,-1, 1,-2,-2,-4,-1,-2,-3, 1, 3,
	 1,-2, 0,-1,-3,-2,-1,-1,-2, 0,-2, 0,-1,-4,-1, 2, 4,
	-6, 1,-4,-7,-8,-6,-8,-7,-3,-6,-2,-5,-5,-1,-6,-2,-6, 12,
	-4,-5,-2,-5,-1,-5,-5,-6, 0,-2,-2,-5,-4, 4,-6,-3,-3,-1, 8,
	 0,-3,-3,-3,-2,-3,-3,-2,-3, 3, 1,-4, 1,-2,-2,-2, 0,-7,-3, 5,
	 0,-2, 3, 4,-5, 0, 2, 0, 1,-3,-4, 0,-3,-5,-2, 0, 0,-5,-3,-3, 3,
	 0,-1, 0, 3,-6, 4, 4,-1, 1,-3,-3, 0,-2,-6,-1,-1,-2,-7,-5,-3, 2, 4,
	-1,-2,-1,-1,-4,-1,-1,-2,-1,-1,-2,-1,-1,-3,-1,-1,-1,-5,-3,-1,-1,-1,-1,
	-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 140 substitution matrix, scale = ln(2)/2 = 0.346574
	//
	// Expected score = -1.35, Entropy = 0.820 bits
	//
	// Lowest score = -8, Highest score = 12
	//
	public final String pam140_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam140 =  { 
	 3,
	-2, 6,
	 0,-1, 3,
	 0,-3, 2, 4,
	-2,-4,-4,-6, 9,
	-1, 1, 0, 1,-6, 5,
	 0,-2, 1, 3,-6, 2, 4,
	 1,-4, 0, 0,-4,-2,-1, 5,
	-2, 1, 2, 0,-4, 3, 0,-3, 6,
	-1,-2,-2,-3,-3,-3,-2,-4,-3, 5,
	-2,-4,-3,-5,-7,-2,-4,-5,-2, 1, 5,
	-2, 3, 1,-1,-6, 0,-1,-3,-1,-2,-3, 5,
	-2,-1,-2,-4,-6,-1,-3,-3,-3, 2, 3, 0, 7,
	-4,-5,-4,-6,-5,-5,-6,-5,-2, 0, 1,-6,-1, 7,
	 1,-1,-1,-2,-3, 0,-1,-1,-1,-3,-3,-2,-3,-5, 6,
	 1,-1, 1, 0, 0,-1,-1, 1,-1,-2,-3,-1,-2,-3, 1, 3,
	 1,-2, 0,-1,-3,-2,-1,-1,-2, 0,-2, 0,-1,-4, 0, 2, 4,
	-6, 1,-4,-7,-8,-5,-8,-7,-3,-6,-2,-4,-5,-1,-6,-2,-5, 12,
	-4,-5,-2,-5,-1,-5,-4,-6, 0,-2,-2,-5,-4, 4,-6,-3,-3,-1, 8,
	 0,-3,-2,-3,-2,-2,-2,-2,-3, 3, 1,-3, 1,-2,-2,-2, 0,-7,-3, 5,
	 0,-2, 3, 4,-5, 1, 2, 0, 1,-2,-4, 0,-3,-5,-2, 0, 0,-5,-3,-3, 3,
	 0,-1, 1, 3,-6, 4, 4,-1, 1,-2,-3, 0,-2,-6,-1,-1,-1,-6,-4,-2, 2, 4,
	-1,-1,-1,-1,-4,-1,-1,-1,-1,-1,-2,-1,-1,-3,-1, 0,-1,-5,-3,-1,-1,-1,-1,
	-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 150 substitution matrix, scale = ln(2)/2 = 0.346574
	//
	// Expected score = -1.25, Entropy = 0.754 bits
	//
	// Lowest score = -7, Highest score = 12
	//
	public final String pam150_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam150 =  { 
	 3,
	-2, 6,
	 0,-1, 3,
	 0,-2, 2, 4,
	-2,-4,-4,-6, 9,
	-1, 1, 0, 1,-6, 5,
	 0,-2, 1, 3,-6, 2, 4,
	 1,-3, 0, 0,-4,-2,-1, 4,
	-2, 1, 2, 0,-3, 3, 0,-3, 6,
	-1,-2,-2,-3,-2,-3,-2,-3,-3, 5,
	-2,-3,-3,-5,-6,-2,-4,-4,-2, 1, 5,
	-2, 3, 1,-1,-6, 0,-1,-2,-1,-2,-3, 4,
	-1,-1,-2,-3,-5,-1,-2,-3,-3, 2, 3, 0, 7,
	-4,-4,-4,-6,-5,-5,-6,-5,-2, 0, 1,-6,-1, 7,
	 1,-1,-1,-2,-3, 0,-1,-1,-1,-3,-3,-2,-3,-5, 6,
	 1,-1, 1, 0, 0,-1,-1, 1,-1,-2,-3,-1,-2,-3, 1, 2,
	 1,-2, 0,-1,-3,-1,-1,-1,-2, 0,-2, 0,-1,-3, 0, 1, 4,
	-6, 1,-4,-7,-7,-5,-7,-7,-3,-5,-2,-4,-5,-1,-6,-2,-5, 12,
	-3,-4,-2,-4, 0,-4,-4,-5, 0,-2,-2,-4,-3, 5,-5,-3,-3,-1, 8,
	 0,-3,-2,-3,-2,-2,-2,-2,-3, 3, 1,-3, 1,-2,-2,-1, 0,-6,-3, 4,
	 0,-2, 3, 3,-5, 1, 2, 0, 1,-2,-4, 0,-3,-5,-2, 0, 0,-5,-3,-2, 3,
	 0, 0, 1, 2,-6, 4, 4,-1, 1,-2,-3, 0,-2,-5,-1,-1,-1,-6,-4,-2, 2, 4,
	-1,-1,-1,-1,-3,-1,-1,-1,-1,-1,-2,-1,-1,-3,-1, 0,-1,-4,-3,-1,-1,-1,-1,
	-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 160 substitution matrix, scale = ln(2)/2 = 0.346574
	//
	// Expected score = -1.14, Entropy = 0.694 bits
	//
	// Lowest score = -7, Highest score = 12
	//
	public final String pam160_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam160 =  { 
	 2,
	-2, 6,
	 0,-1, 3,
	 0,-2, 2, 4,
	-2,-3,-4,-5, 9,
	-1, 1, 0, 1,-5, 5,
	 0,-2, 1, 3,-5, 2, 4,
	 1,-3, 0, 0,-3,-2, 0, 4,
	-2, 1, 2, 0,-3, 2, 0,-3, 6,
	-1,-2,-2,-3,-2,-2,-2,-3,-3, 5,
	-2,-3,-3,-4,-6,-2,-3,-4,-2, 2, 5,
	-2, 3, 1, 0,-5, 0,-1,-2,-1,-2,-3, 4,
	-1,-1,-2,-3,-5,-1,-2,-3,-3, 2, 3, 0, 7,
	-3,-4,-3,-6,-5,-5,-5,-4,-2, 0, 1,-5, 0, 7,
	 1,-1,-1,-2,-3, 0,-1,-1,-1,-2,-3,-2,-2,-4, 5,
	 1,-1, 1, 0, 0,-1, 0, 1,-1,-2,-3,-1,-2,-3, 1, 2,
	 1,-1, 0,-1,-2,-1,-1,-1,-2, 0,-2, 0,-1,-3, 0, 1, 3,
	-5, 1,-4,-6,-7,-5,-7,-7,-3,-5,-2,-4,-4,-1,-5,-2,-5, 12,
	-3,-4,-2,-4, 0,-4,-4,-5, 0,-2,-2,-4,-3, 5,-5,-3,-3,-1, 8,
	 0,-3,-2,-3,-2,-2,-2,-2,-2, 3, 1,-3, 1,-2,-2,-1, 0,-6,-3, 4,
	 0,-1, 2, 3,-4, 1, 2, 0, 1,-2,-4, 0,-3,-4,-1, 0, 0,-5,-3,-2, 3,
	 0, 0, 1, 2,-5, 3, 3,-1, 1,-2,-3, 0,-2,-5,-1,-1,-1,-6,-4,-2, 2, 3,
	 0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-2,-1,-1,-3,-1, 0, 0,-4,-3,-1,-1,-1,-1,
	-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 170 substitution matrix, scale = ln(2)/3 = 0.231049
	//
	// Expected score = -1.57, Entropy = 0.640 bits
	//
	// Lowest score = -10, Highest score = 18
	//
	public final String pam170_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam170 =  { 
	 3,
	-3, 8,
	 0,-1, 4,
	 0,-3, 3, 6,
	-3,-5,-5,-7, 13,
	-1, 1, 0, 2,-8, 6,
	 0,-2, 2, 5,-8, 3, 6,
	 1,-4, 0, 0,-5,-2, 0, 6,
	-3, 2, 2, 0,-5, 4, 0,-4, 9,
	-1,-3,-3,-4,-3,-3,-3,-4,-4, 7,
	-3,-4,-4,-6,-9,-2,-5,-6,-3, 2, 7,
	-2, 4, 1,-1,-8, 0,-1,-3,-1,-3,-4, 6,
	-2,-1,-3,-4,-7,-1,-3,-4,-4, 2, 4, 1, 10,
	-5,-6,-5,-8,-6,-7,-8,-6,-3, 1, 1,-8, 0, 10,
	 1,-1,-1,-2,-4, 0,-1,-2,-1,-3,-4,-2,-3,-6, 8,
	 2,-1, 1, 0, 0,-1,-1, 1,-2,-2,-4,-1,-2,-4, 1, 3,
	 2,-2, 0,-1,-3,-2,-1,-1,-2, 0,-3, 0,-1,-5, 0, 2, 5,
	-8, 2,-5,-9,-10,-7,-10,-9,-4,-7,-3,-5,-6,-1,-8,-3,-7, 18,
	-5,-6,-3,-6, 0,-6,-6,-7, 0,-2,-2,-6,-4, 7,-7,-4,-4,-1, 12,
	 0,-4,-3,-4,-3,-3,-3,-2,-3, 5, 2,-4, 2,-2,-2,-2, 0,-9,-4, 6,
	 0,-2, 3, 5,-6, 1, 3, 0, 1,-3,-5, 0,-4,-6,-2, 1, 0,-7,-4,-3, 4,
	 0, 0, 1, 4,-8, 5, 5,-1, 2,-3,-4, 0,-2,-7,-1,-1,-1,-8,-6,-3, 3, 5,
	-1,-2,-1,-1,-4,-1,-1,-2,-1,-1,-2,-2,-1,-4,-1, 0,-1,-6,-4,-1,-1,-1,-2,
	-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 180 substitution matrix, scale = ln(2)/3 = 0.231049
	//
	// Expected score = -1.51, Entropy = 0.591 bits
	//
	// Lowest score = -10, Highest score = 18
	//
	public final String pam180_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam180 =  { 
	 3,
	-3, 8,
	 0,-1, 4,
	 0,-3, 3, 5,
	-3,-5,-5,-7, 13,
	-1, 1, 0, 2,-7, 6,
	 0,-2, 2, 4,-7, 3, 5,
	 1,-4, 0, 0,-5,-2, 0, 6,
	-2, 2, 2, 0,-4, 4, 0,-3, 8,
	-1,-3,-3,-3,-3,-3,-3,-4,-4, 6,
	-3,-4,-4,-6,-8,-2,-5,-6,-3, 2, 7,
	-2, 4, 1, 0,-7, 0,-1,-3,-1,-3,-4, 6,
	-2,-1,-3,-4,-7,-1,-3,-4,-3, 2, 4, 1, 9,
	-5,-6,-5,-8,-6,-6,-7,-6,-3, 1, 1,-7, 0, 10,
	 1,-1,-1,-2,-4, 0,-1,-1,-1,-3,-4,-2,-3,-6, 8,
	 1,-1, 1, 0, 0,-1,-1, 1,-2,-2,-4,-1,-2,-4, 1, 3,
	 2,-2, 0,-1,-3,-2,-1,-1,-2, 0,-3, 0,-1,-4, 0, 2, 4,
	-8, 2,-5,-9,-10,-6,-9,-9,-4,-7,-3,-5,-6, 0,-7,-3,-7, 18,
	-5,-6,-2,-6, 0,-6,-6,-7, 0,-2,-2,-6,-4, 7,-7,-4,-4,-1, 11,
	 0,-4,-3,-3,-3,-3,-3,-2,-3, 5, 2,-4, 2,-2,-2,-2, 0,-8,-4, 6,
	 0,-2, 3, 4,-6, 1, 3, 0, 1,-3,-5, 0,-3,-6,-2, 1, 0,-7,-4,-3, 4,
	 0, 0, 1, 3,-7, 5, 5,-1, 2,-3,-3, 0,-2,-7,-1,-1,-1,-8,-6,-3, 3, 5,
	-1,-2,-1,-1,-4,-1,-1,-2,-1,-1,-2,-1,-1,-3,-1, 0,-1,-6,-3,-1,-1,-1,-1,
	-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 190 substitution matrix, scale = ln(2)/3 = 0.231049
	//
	// Expected score = -1.35, Entropy = 0.547 bits
	//
	// Lowest score = -9, Highest score = 18
	//
	public final String pam190_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam190 =  { 
	 3,
	-2, 8,
	 0,-1, 3,
	 0,-2, 3, 5,
	-3,-5,-5,-7, 13,
	-1, 1, 1, 2,-7, 6,
	 0,-2, 2, 4,-7, 3, 5,
	 1,-4, 0, 0,-4,-2, 0, 6,
	-2, 2, 2, 0,-4, 3, 0,-3, 8,
	-1,-3,-2,-3,-3,-3,-3,-4,-3, 6,
	-3,-4,-4,-5,-8,-2,-4,-5,-3, 2, 7,
	-2, 4, 1, 0,-7, 1,-1,-3,-1,-3,-4, 6,
	-2,-1,-3,-4,-7,-1,-3,-4,-3, 2, 4, 1, 9,
	-5,-6,-4,-7,-6,-6,-7,-6,-2, 1, 2,-7, 0, 10,
	 1, 0,-1,-2,-4, 0,-1,-1,-1,-3,-3,-2,-3,-6, 7,
	 1,-1, 1, 0, 0,-1, 0, 1,-1,-2,-4, 0,-2,-4, 1, 3,
	 2,-2, 0,-1,-3,-1,-1,-1,-2, 0,-2, 0,-1,-4, 0, 2, 4,
	-7, 2,-5,-8,-9,-6,-9,-9,-3,-7,-3,-5,-6, 0,-7,-3,-6, 18,
	-4,-5,-2,-5, 0,-5,-5,-7, 0,-2,-2,-6,-4, 7,-6,-4,-3,-1, 11,
	 0,-3,-3,-3,-3,-3,-3,-2,-3, 4, 2,-3, 2,-2,-2,-2, 0,-8,-3, 6,
	 0,-1, 3, 4,-6, 1, 3, 0, 1,-3,-5, 0,-3,-6,-1, 1, 0,-6,-4,-3, 4,
	 0, 0, 1, 3,-7, 4, 4,-1, 2,-3,-3, 0,-2,-7,-1,-1,-1,-7,-5,-3, 2, 4,
	 0,-1,-1,-1,-4,-1,-1,-1,-1,-1,-2,-1,-1,-3,-1, 0, 0,-5,-3,-1,-1,-1,-1,
	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 20 substitution matrix, scale = ln(2)/2 = 0.346574
	//
	// Expected score = -6.18, Entropy = 2.95 bits
	//
	// Lowest score = -19, Highest score = 13
	//
	public final String pam20_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam20 =  { 
	 6,
	-8, 9,
	-5,-7, 8,
	-4,-12, 1, 8,
	-8,-9,-13,-16, 10,
	-5,-2,-5,-4,-16, 9,
	-3,-11,-3, 2,-16, 0, 8,
	-3,-11,-4,-4,-11,-8,-5, 7,
	-8,-3,-1,-5,-8, 0,-6,-10, 9,
	-6,-6,-6,-9,-7,-9,-6,-13,-11, 9,
	-7,-10,-8,-15,-17,-6,-10,-12,-7,-2, 7,
	-8,-1,-2,-6,-16,-4,-5,-8,-8,-7,-9, 7,
	-6,-5,-11,-13,-16,-5,-8,-10,-13,-2, 0,-3, 11,
	-9,-10,-10,-17,-15,-15,-16,-10,-7,-3,-4,-16,-5, 9,
	-2,-5,-7,-9,-9,-4,-7,-7,-5,-10,-8,-8,-9,-11, 8,
	-1,-4,-1,-5,-4,-6,-5,-3,-7,-8,-9,-5,-6,-7,-3, 7,
	-1,-8,-3,-6,-9,-7,-7,-7,-8,-3,-8,-4,-5,-10,-5, 0, 7,
	-16,-3,-9,-17,-18,-15,-19,-17,-8,-16,-7,-14,-15,-6,-16,-6,-15, 13,
	-9,-11,-5,-13,-5,-14,-9,-16,-4,-7,-8,-10,-13, 1,-16,-8,-7,-6, 10,
	-3,-9,-9,-9,-7,-8,-8,-7,-7, 1,-3,-10,-2,-9,-7,-8,-4,-18,-8, 7,
	-5,-9, 6, 6,-14,-4, 0,-4,-2,-7,-10,-3,-12,-12,-8,-2,-4,-11,-7,-9, 6,
	-4,-5,-4, 0,-16, 7, 6,-6,-2,-7,-8,-5,-6,-16,-5,-6,-7,-17,-11,-8,-1, 6,
	-4,-7,-4,-7,-11,-6,-6,-6,-6,-6,-7,-6,-6,-9,-6,-4,-5,-13,-9,-6,-6,-6,-6,
	-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 200 substitution matrix, scale = ln(2)/3 = 0.231049
	//
	// Expected score = -1.23, Entropy = 0.507 bits
	//
	// Lowest score = -9, Highest score = 18
	//
	public final String pam200_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam200 =  { 
	 3,
	-2, 7,
	 0, 0, 3,
	 0,-2, 3, 5,
	-3,-4,-5,-6, 12,
	-1, 1, 1, 2,-7, 5,
	 0,-2, 2, 4,-7, 3, 5,
	 1,-4, 0, 0,-4,-2, 0, 6,
	-2, 2, 2, 0,-4, 3, 0,-3, 8,
	-1,-2,-2,-3,-3,-3,-3,-3,-3, 6,
	-2,-4,-4,-5,-7,-2,-4,-5,-3, 2, 7,
	-2, 4, 1, 0,-7, 1, 0,-2,-1,-2,-4, 6,
	-2,-1,-2,-4,-6,-1,-3,-4,-3, 2, 4, 1, 8,
	-4,-5,-4,-7,-6,-6,-7,-6,-2, 1, 2,-7, 0, 10,
	 1, 0,-1,-2,-4, 0,-1,-1,-1,-3,-3,-2,-3,-6, 7,
	 1,-1, 1, 0, 0,-1, 0, 1,-1,-2,-4, 0,-2,-4, 1, 2,
	 1,-1, 0, 0,-3,-1,-1, 0,-2, 0,-2, 0,-1,-4, 0, 2, 4,
	-7, 2,-5,-8,-9,-6,-9,-8,-3,-6,-2,-4,-5, 0,-7,-3,-6, 18,
	-4,-5,-2,-5, 0,-5,-5,-6, 0,-2,-2,-5,-3, 7,-6,-3,-3,-1, 11,
	 0,-3,-2,-3,-2,-3,-2,-2,-3, 4, 2,-3, 2,-2,-2,-1, 0,-8,-3, 5,
	 0,-1, 3, 4,-5, 1, 3, 0, 1,-3,-4, 0,-3,-6,-1, 1, 0,-6,-4,-3, 3,
	 0, 0, 1, 3,-7, 4, 4,-1, 2,-3,-3, 0,-2,-6,-1,-1,-1,-7,-5,-2, 2, 4,
	 0,-1, 0,-1,-4,-1,-1,-1,-1,-1,-2,-1,-1,-3,-1, 0, 0,-5,-3,-1,-1,-1,-1,
	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 210 substitution matrix, scale = ln(2)/3 = 0.231049
	//
	// Expected score = -1.12, Entropy = 0.470 bits
	//
	// Lowest score = -9, Highest score = 18
	//
	public final String pam210_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam210 =  { 
	 2,
	-2, 7,
	 0, 0, 3,
	 0,-2, 2, 5,
	-2,-4,-4,-6, 12,
	-1, 1, 1, 2,-6, 5,
	 0,-2, 2, 4,-6, 3, 5,
	 1,-3, 0, 0,-4,-2, 0, 5,
	-2, 2, 2, 1,-4, 3, 0,-3, 8,
	-1,-2,-2,-3,-3,-3,-2,-3,-3, 5,
	-2,-4,-3,-5,-7,-2,-4,-5,-2, 2, 7,
	-2, 4, 1, 0,-6, 1, 0,-2, 0,-2,-3, 5,
	-1,-1,-2,-3,-6,-1,-3,-3,-3, 2, 4, 1, 8,
	-4,-5,-4,-7,-5,-6,-6,-5,-2, 1, 2,-6, 0, 10,
	 1, 0,-1,-1,-3, 0,-1,-1, 0,-3,-3,-2,-3,-5, 7,
	 1, 0, 1, 0, 0,-1, 0, 1,-1,-2,-3, 0,-2,-4, 1, 2,
	 1,-1, 0, 0,-3,-1,-1, 0,-2, 0,-2, 0,-1,-4, 0, 2, 3,
	-7, 2,-5,-8,-9,-6,-8,-8,-3,-6,-2,-4,-5, 0,-7,-3,-6, 18,
	-4,-5,-2,-5, 0,-5,-5,-6, 0,-1,-1,-5,-3, 7,-6,-3,-3,-1, 11,
	 0,-3,-2,-3,-2,-2,-2,-2,-3, 4, 2,-3, 2,-2,-2,-1, 0,-7,-3, 5,
	 0,-1, 3, 4,-5, 1, 3, 0, 1,-3,-4, 0,-3,-5,-1, 1, 0,-6,-4,-2, 3,
	 0, 0, 1, 3,-6, 4, 4,-1, 2,-3,-3, 0,-2,-6, 0, 0,-1,-7,-5,-2, 2, 4,
	 0,-1, 0,-1,-4,-1,-1,-1,-1,-1,-2,-1,-1,-3,-1, 0, 0,-5,-3,-1,-1,-1,-1,
	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 220 substitution matrix, scale = ln(2)/3 = 0.231049
	//
	// Expected score = -1.06, Entropy = 0.437 bits
	//
	// Lowest score = -8, Highest score = 17
	//
	public final String pam220_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam220 =  { 
	 2,
	-2, 7,
	 0, 0, 3,
	 0,-2, 2, 4,
	-2,-4,-4,-6, 12,
	-1, 1, 1, 2,-6, 5,
	 0,-1, 2, 4,-6, 3, 4,
	 1,-3, 0, 0,-4,-2, 0, 5,
	-2, 2, 2, 1,-4, 3, 1,-3, 7,
	-1,-2,-2,-3,-3,-2,-2,-3,-3, 5,
	-2,-3,-3,-5,-7,-2,-4,-5,-2, 2, 6,
	-1, 4, 1, 0,-6, 1, 0,-2, 0,-2,-3, 5,
	-1,-1,-2,-3,-6,-1,-2,-3,-3, 2, 4, 1, 8,
	-4,-5,-4,-6,-5,-5,-6,-5,-2, 1, 2,-6, 0, 10,
	 1, 0,-1,-1,-3, 0,-1,-1, 0,-2,-3,-1,-2,-5, 7,
	 1, 0, 1, 0, 0,-1, 0, 1,-1,-2,-3, 0,-2,-4, 1, 2,
	 1,-1, 0, 0,-3,-1,-1, 0,-2, 0,-2, 0,-1,-4, 0, 2, 3,
	-6, 2,-4,-8,-8,-5,-8,-8,-3,-6,-2,-4,-5, 0,-6,-3,-6, 17,
	-4,-5,-2,-5, 0,-5,-5,-6, 0,-1,-1,-5,-3, 7,-6,-3,-3, 0, 11,
	 0,-3,-2,-3,-2,-2,-2,-2,-3, 4, 2,-3, 2,-2,-1,-1, 0,-7,-3, 5,
	 0,-1, 2, 4,-5, 1, 3, 0, 1,-2,-4, 0,-3,-5,-1, 0, 0,-6,-3,-2, 3,
	 0, 0, 1, 3,-6, 4, 4,-1, 2,-2,-3, 0,-2,-6, 0, 0,-1,-7,-5,-2, 2, 4,
	 0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-2,-1,-1,-3,-1, 0, 0,-5,-3,-1,-1,-1,-1,
	-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 230 substitution matrix, scale = ln(2)/3 = 0.231049
	//
	// Expected score = -0.991, Entropy = 0.407 bits
	//
	// Lowest score = -8, Highest score = 17
	//
	public final String pam230_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam230 =  { 
	 2,
	-2, 7,
	 0, 0, 2,
	 0,-2, 2, 4,
	-2,-4,-4,-6, 12,
	-1, 1, 1, 2,-6, 5,
	 0,-1, 1, 4,-6, 3, 4,
	 1,-3, 0, 1,-4,-1, 0, 5,
	-2, 2, 2, 1,-4, 3, 1,-2, 7,
	-1,-2,-2,-3,-2,-2,-2,-3,-3, 5,
	-2,-3,-3,-4,-7,-2,-4,-4,-2, 2, 6,
	-1, 4, 1, 0,-6, 1, 0,-2, 0,-2,-3, 5,
	-1,-1,-2,-3,-6,-1,-2,-3,-2, 2, 4, 0, 7,
	-4,-5,-4,-6,-5,-5,-6,-5,-2, 1, 2,-6, 0, 9,
	 1, 0,-1,-1,-3, 0,-1,-1, 0,-2,-3,-1,-2,-5, 6,
	 1, 0, 1, 0, 0,-1, 0, 1,-1,-2,-3, 0,-2,-3, 1, 2,
	 1,-1, 0, 0,-2,-1,-1, 0,-2, 0,-2, 0,-1,-3, 0, 2, 3,
	-6, 2,-4,-7,-8,-5,-8,-7,-3,-6,-2,-4,-5, 0,-6,-3,-6, 17,
	-4,-5,-2,-5, 0,-4,-5,-6, 0,-1,-1,-5,-3, 7,-5,-3,-3, 0, 10,
	 0,-3,-2,-2,-2,-2,-2,-2,-2, 4, 2,-3, 2,-1,-1,-1, 0,-7,-3, 5,
	 0,-1, 2, 3,-5, 1, 3, 0, 1,-2,-4, 1,-2,-5,-1, 0, 0,-6,-3,-2, 3,
	 0, 0, 1, 3,-6, 4, 4,-1, 2,-2,-3, 0,-2,-6, 0, 0,-1,-6,-5,-2, 2, 4,
	 0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-2,-1,-1,-3,-1, 0, 0,-4,-3,-1,-1,-1,-1,
	-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 240 substitution matrix, scale = ln(2)/3 = 0.231049
	//
	// Expected score = -0.923, Entropy = 0.379 bits
	//
	// Lowest score = -8, Highest score = 17
	//
	public final String pam240_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam240 =  { 
	 2,
	-2, 6,
	 0, 0, 2,
	 0,-1, 2, 4,
	-2,-4,-4,-5, 12,
	 0, 1, 1, 2,-6, 4,
	 0,-1, 1, 4,-6, 3, 4,
	 1,-3, 0, 1,-4,-1, 0, 5,
	-1, 2, 2, 1,-4, 3, 1,-2, 7,
	-1,-2,-2,-2,-2,-2,-2,-3,-3, 5,
	-2,-3,-3,-4,-6,-2,-3,-4,-2, 2, 6,
	-1, 3, 1, 0,-6, 1, 0,-2, 0,-2,-3, 5,
	-1, 0,-2,-3,-5,-1,-2,-3,-2, 2, 4, 0, 7,
	-4,-5,-4,-6,-5,-5,-6,-5,-2, 1, 2,-5, 0, 9,
	 1, 0,-1,-1,-3, 0,-1,-1, 0,-2,-3,-1,-2,-5, 6,
	 1, 0, 1, 0, 0,-1, 0, 1,-1,-1,-3, 0,-2,-3, 1, 2,
	 1,-1, 0, 0,-2,-1, 0, 0,-1, 0,-2, 0,-1,-3, 0, 1, 3,
	-6, 2,-4,-7,-8,-5,-7,-7,-3,-5,-2,-4,-4, 0,-6,-3,-5, 17,
	-4,-4,-2,-4, 0,-4,-4,-5, 0,-1,-1,-5,-3, 7,-5,-3,-3, 0, 10,
	 0,-3,-2,-2,-2,-2,-2,-1,-2, 4, 2,-3, 2,-1,-1,-1, 0,-6,-3, 4,
	 0,-1, 2, 3,-5, 1, 3, 0, 1,-2,-4, 1,-2,-5,-1, 0, 0,-5,-3,-2, 3,
	 0, 0, 1, 3,-6, 3, 3, 0, 2,-2,-3, 0,-2,-5, 0, 0,-1,-6,-4,-2, 2, 3,
	 0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-1,-1,-1,-2,-1, 0, 0,-4,-2,-1,-1,-1,-1,
	-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 250 substitution matrix, scale = ln(2)/3 = 0.231049
	//
	// Expected score = -0.844, Entropy = 0.354 bits
	//
	// Lowest score = -8, Highest score = 17
	//
	public final String pam250_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam250 =  { 
	 2,
	-2, 6,
	 0, 0, 2,
	 0,-1, 2, 4,
	-2,-4,-4,-5, 12,
	 0, 1, 1, 2,-5, 4,
	 0,-1, 1, 3,-5, 2, 4,
	 1,-3, 0, 1,-3,-1, 0, 5,
	-1, 2, 2, 1,-3, 3, 1,-2, 6,
	-1,-2,-2,-2,-2,-2,-2,-3,-2, 5,
	-2,-3,-3,-4,-6,-2,-3,-4,-2, 2, 6,
	-1, 3, 1, 0,-5, 1, 0,-2, 0,-2,-3, 5,
	-1, 0,-2,-3,-5,-1,-2,-3,-2, 2, 4, 0, 6,
	-3,-4,-3,-6,-4,-5,-5,-5,-2, 1, 2,-5, 0, 9,
	 1, 0, 0,-1,-3, 0,-1, 0, 0,-2,-3,-1,-2,-5, 6,
	 1, 0, 1, 0, 0,-1, 0, 1,-1,-1,-3, 0,-2,-3, 1, 2,
	 1,-1, 0, 0,-2,-1, 0, 0,-1, 0,-2, 0,-1,-3, 0, 1, 3,
	-6, 2,-4,-7,-8,-5,-7,-7,-3,-5,-2,-3,-4, 0,-6,-2,-5, 17,
	-3,-4,-2,-4, 0,-4,-4,-5, 0,-1,-1,-4,-2, 7,-5,-3,-3, 0, 10,
	 0,-2,-2,-2,-2,-2,-2,-1,-2, 4, 2,-2, 2,-1,-1,-1, 0,-6,-2, 4,
	 0,-1, 2, 3,-4, 1, 3, 0, 1,-2,-3, 1,-2,-4,-1, 0, 0,-5,-3,-2, 3,
	 0, 0, 1, 3,-5, 3, 3, 0, 2,-2,-3, 0,-2,-5, 0, 0,-1,-6,-4,-2, 2, 3,
	 0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-1,-1,-1,-2,-1, 0, 0,-4,-2,-1,-1,-1,-1,
	-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 260 substitution matrix, scale = ln(2)/3 = 0.231049
	//
	// Expected score = -0.794, Entropy = 0.330 bits
	//
	// Lowest score = -7, Highest score = 17
	//
	public final String pam260_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam260 =  { 
	 2,
	-1, 6,
	 0, 0, 2,
	 0,-1, 2, 4,
	-2,-4,-3,-5, 12,
	 0, 1, 1, 2,-5, 4,
	 0,-1, 1, 3,-5, 2, 4,
	 1,-2, 0, 1,-3,-1, 0, 5,
	-1, 2, 2, 1,-3, 3, 1,-2, 6,
	 0,-2,-2,-2,-2,-2,-2,-2,-2, 4,
	-2,-3,-3,-4,-6,-2,-3,-4,-2, 2, 6,
	-1, 3, 1, 0,-5, 1, 0,-2, 0,-2,-3, 4,
	-1, 0,-2,-2,-5,-1,-2,-3,-2, 2, 4, 0, 6,
	-3,-4,-3,-5,-4,-4,-5,-5,-2, 1, 2,-5, 0, 9,
	 1, 0, 0,-1,-3, 0, 0, 0, 0,-2,-2,-1,-2,-4, 6,
	 1, 0, 1, 0, 0, 0, 0, 1,-1,-1,-3, 0,-1,-3, 1, 1,
	 1,-1, 0, 0,-2,-1, 0, 0,-1, 0,-2, 0,-1,-3, 0, 1, 2,
	-6, 2,-4,-6,-7,-5,-7,-7,-3,-5,-2,-3,-4, 0,-5,-2,-5, 17,
	-3,-4,-2,-4, 0,-4,-4,-5, 0,-1,-1,-4,-2, 7,-5,-3,-3, 0, 10,
	 0,-2,-2,-2,-2,-2,-2,-1,-2, 4, 2,-2, 2,-1,-1,-1, 0,-6,-2, 4,
	 0,-1, 2, 3,-4, 1, 3, 1, 1,-2,-3, 1,-2,-4,-1, 0, 0,-5,-3,-2, 3,
	 0, 0, 1, 3,-5, 3, 3, 0, 2,-2,-2, 0,-2,-5, 0, 0, 0,-6,-4,-2, 2, 3,
	 0,-1, 0,-1,-3, 0,-1,-1,-1,-1,-1,-1,-1,-2,-1, 0, 0,-4,-2,-1, 0,-1,-1,
	-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 270 substitution matrix, scale = ln(2)/4 = 0.173287
	//
	// Expected score = -0.969, Entropy = 0.309 bits
	//
	// Lowest score = -10, Highest score = 23
	//
	public final String pam270_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam270 =  { 
	 2,
	-2, 8,
	 0, 0, 2,
	 0,-1, 2, 5,
	-2,-5,-4,-6, 16,
	 0, 2, 1, 2,-7, 5,
	 0,-1, 2, 4,-6, 3, 5,
	 2,-3, 1, 1,-4,-1, 0, 6,
	-2, 2, 2, 1,-4, 4, 1,-2, 8,
	-1,-2,-2,-3,-3,-2,-2,-3,-3, 5,
	-2,-4,-3,-5,-7,-2,-4,-5,-3, 3, 8,
	-1, 4, 1, 0,-7, 1, 0,-2, 0,-2,-3, 6,
	-1,-1,-2,-3,-6,-1,-3,-3,-3, 3, 5, 0, 8,
	-4,-5,-4,-7,-5,-6,-7,-6,-2, 1, 2,-6, 0, 12,
	 1, 0, 0,-1,-3, 0,-1, 0, 0,-2,-3,-1,-2,-6, 7,
	 1, 0, 1, 0, 0,-1, 0, 1,-1,-2,-3, 0,-2,-4, 1, 2,
	 1,-1, 1, 0,-3,-1, 0, 0,-1, 0,-2, 0,-1,-4, 0, 2, 3,
	-7, 3,-5,-8,-10,-6,-9,-9,-3,-6,-2,-4,-5, 1,-7,-3,-6, 23,
	-4,-5,-3,-5, 1,-5,-5,-6, 0,-1,-1,-5,-3, 9,-6,-4,-3, 0, 13,
	 0,-3,-2,-3,-2,-2,-2,-2,-3, 5, 2,-3, 2,-1,-1,-1, 0,-8,-3, 5,
	 0,-1, 2, 4,-5, 2, 3, 1, 1,-3,-4, 1,-3,-6,-1, 1, 0,-7,-4,-2, 3,
	 0, 0, 2, 3,-7, 4, 4, 0, 2,-2,-3, 0,-2,-6, 0, 0,-1,-7,-5,-2, 3, 4,
	 0,-1, 0,-1,-4,-1,-1,-1,-1,-1,-2,-1,-1,-3,-1, 0, 0,-5,-3,-1,-1,-1,-1,
	-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 280 substitution matrix, scale = ln(2)/4 = 0.173287
	//
	// Expected score = -0.916, Entropy = 0.289 bits
	//
	// Lowest score = -9, Highest score = 22
	//
	public final String pam280_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam280 =  { 
	 2,
	-2, 7,
	 0, 0, 2,
	 0,-1, 2, 4,
	-2,-4,-4,-6, 15,
	 0, 2, 1, 2,-6, 4,
	 0,-1, 2, 4,-6, 3, 4,
	 2,-3, 1, 1,-4,-1, 0, 6,
	-1, 2, 2, 1,-4, 3, 1,-2, 8,
	-1,-2,-2,-3,-3,-2,-2,-3,-3, 5,
	-2,-3,-3,-5,-7,-2,-4,-5,-2, 3, 7,
	-1, 4, 1, 0,-6, 1, 0,-2, 0,-2,-3, 6,
	-1, 0,-2,-3,-6,-1,-2,-3,-2, 3, 5, 0, 7,
	-4,-5,-4,-7,-5,-5,-6,-6,-2, 1, 2,-6, 0, 11,
	 1, 0, 0,-1,-3, 0, 0, 0, 0,-2,-3,-1,-2,-5, 7,
	 1, 0, 1, 0, 0, 0, 0, 1,-1,-2,-3, 0,-2,-4, 1, 2,
	 1,-1, 1, 0,-3,-1, 0, 0,-1, 0,-2, 0,-1,-4, 1, 1, 3,
	-7, 3,-5,-8,-9,-6,-8,-8,-3,-6,-2,-4,-5, 1,-7,-3,-6, 22,
	-4,-5,-3,-5, 1,-5,-5,-6, 0,-1,-1,-5,-3, 9,-6,-3,-3, 0, 13,
	 0,-3,-2,-2,-2,-2,-2,-1,-3, 4, 2,-3, 2,-1,-1,-1, 0,-7,-3, 5,
	 0,-1, 2, 4,-5, 2, 3, 1, 1,-2,-4, 1,-2,-5,-1, 1, 0,-6,-4,-2, 3,
	 0, 0, 1, 3,-6, 4, 4, 0, 2,-2,-3, 1,-2,-6, 0, 0, 0,-7,-5,-2, 2, 4,
	 0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-1,-1,-1,-3,-1, 0, 0,-5,-3,-1,-1,-1,-1,
	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 290 substitution matrix, scale = ln(2)/4 = 0.173287
	//
	// Expected score = -0.877, Entropy = 0.271 bits
	//
	// Lowest score = -9, Highest score = 22
	//
	public final String pam290_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam290 =  { 
	 2,
	-2, 7,
	 0, 0, 2,
	 0,-1, 2, 4,
	-2,-4,-4,-6, 15,
	 0, 2, 1, 2,-6, 4,
	 0,-1, 2, 4,-6, 3, 4,
	 2,-3, 1, 1,-4,-1, 0, 5,
	-1, 2, 2, 1,-4, 3, 1,-2, 7,
	-1,-2,-2,-3,-3,-2,-2,-3,-3, 5,
	-2,-3,-3,-4,-7,-2,-4,-4,-2, 3, 7,
	-1, 4, 1, 0,-6, 1, 0,-2, 0,-2,-3, 5,
	-1, 0,-2,-3,-6,-1,-2,-3,-2, 3, 5, 0, 7,
	-4,-5,-4,-6,-5,-5,-6,-6,-2, 1, 3,-6, 0, 11,
	 1, 0, 0,-1,-3, 0, 0, 0, 0,-2,-3,-1,-2,-5, 7,
	 1, 0, 1, 0, 0, 0, 0, 1,-1,-1,-3, 0,-2,-4, 1, 2,
	 1,-1, 1, 0,-2,-1, 0, 0,-1, 0,-2, 0,-1,-3, 1, 1, 3,
	-7, 3,-5,-8,-9,-5,-8,-8,-3,-6,-2,-4,-5, 1,-6,-3,-6, 22,
	-4,-5,-3,-5, 1,-5,-5,-6, 0,-1,-1,-5,-2, 9,-6,-3,-3, 0, 13,
	 0,-3,-2,-2,-2,-2,-2,-1,-2, 4, 2,-3, 2,-1,-1,-1, 0,-7,-3, 5,
	 0, 0, 2, 3,-5, 2, 3, 1, 1,-2,-4, 1,-2,-5,-1, 1, 0,-6,-4,-2, 3,
	 0, 0, 1, 3,-6, 3, 4, 0, 2,-2,-3, 1,-2,-6, 0, 0, 0,-7,-5,-2, 2, 4,
	 0,-1, 0,-1,-3, 0,-1,-1,-1,-1,-1,-1,-1,-3,-1, 0, 0,-5,-2,-1, 0,-1,-1,
	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 30 substitution matrix, scale = ln(2)/2 = 0.346574
	//
	// Expected score = -5.06, Entropy = 2.57 bits
	//
	// Lowest score = -17, Highest score = 13
	//
	public final String pam30_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam30 =  { 
	 6,
	-7, 8,
	-4,-6, 8,
	-3,-10, 2, 8,
	-6,-8,-11,-14, 10,
	-4,-2,-3,-2,-14, 8,
	-2,-9,-2, 2,-14, 1, 8,
	-2,-9,-3,-3,-9,-7,-4, 6,
	-7,-2, 0,-4,-7, 1,-5,-9, 9,
	-5,-5,-5,-7,-6,-8,-5,-11,-9, 8,
	-6,-8,-7,-12,-15,-5,-9,-10,-6,-1, 7,
	-7, 0,-1,-4,-14,-3,-4,-7,-6,-6,-8, 7,
	-5,-4,-9,-11,-13,-4,-7,-8,-10,-1, 1,-2, 11,
	-8,-9,-9,-15,-13,-13,-14,-9,-6,-2,-3,-14,-4, 9,
	-2,-4,-6,-8,-8,-3,-5,-6,-4,-8,-7,-6,-8,-10, 8,
	 0,-3, 0,-4,-3,-5,-4,-2,-6,-7,-8,-4,-5,-6,-2, 6,
	-1,-6,-2,-5,-8,-5,-6,-6,-7,-2,-7,-3,-4,-9,-4, 0, 7,
	-13,-2,-8,-15,-15,-13,-17,-15,-7,-14,-6,-12,-13,-4,-14,-5,-13, 13,
	-8,-10,-4,-11,-4,-12,-8,-14,-3,-6,-7,-9,-11, 2,-13,-7,-6,-5, 10,
	-2,-8,-8,-8,-6,-7,-6,-5,-6, 2,-2,-9,-1,-8,-6,-6,-3,-15,-7, 7,
	-3,-7, 6, 6,-12,-3, 1,-3,-1,-6,-9,-2,-10,-10,-7,-1,-3,-10,-6,-8, 6,
	-3,-4,-3, 1,-14, 6, 6,-5,-1,-6,-7,-4,-5,-13,-4,-5,-6,-14,-9,-6, 0, 6,
	-3,-6,-3,-5,-9,-5,-5,-5,-5,-5,-6,-5,-5,-8,-5,-3,-4,-11,-7,-5,-5,-5,-5,
	-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17, 1
	};


	//
	// This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
	//
	// PAM 300 substitution matrix, scale = ln(2)/4 = 0.173287
	//
	// Expected score = -0.835, Entropy = 0.254 bits
	//
	// Lowest score = -9, Highest score = 22
	//
	public final String pam300_Alphabet = "ARNDCQEGHILKMFPSTWYVBZX*";
	public final int[] pam300 =  { 
	 2,
	-1, 7,
	 0, 0, 2,
	 0,-1, 2, 4,
	-2,-4,-4,-6, 15,
	 0, 2, 1, 2,-6, 4,
	 0,-1, 2, 4,-6, 3, 4,
	 2,-2, 1, 1,-4,-1, 0, 5,
	-1, 2, 2, 1,-4, 3, 1,-2, 7,
	 0,-2,-2,-2,-3,-2,-2,-3,-2, 5,
	-2,-3,-3,-4,-7,-2,-4,-4,-2, 3, 7,
	-1, 4, 1, 0,-6, 1, 0,-2, 0,-2,-3, 5,
	-1, 0,-2,-3,-6,-1,-2,-3,-2, 3, 4, 0, 6,
	-4,-5,-4,-6,-5,-5,-6,-5,-2, 1, 3,-6, 1, 11,
	 1, 0, 0,-1,-3, 0, 0, 0, 0,-2,-3,-1,-2,-5, 6,
	 1, 0, 1, 0, 0, 0, 0, 1,-1,-1,-3, 0,-2,-4, 1, 1,
	 1,-1, 0, 0,-2,-1, 0, 0,-1, 0,-2, 0,-1,-3, 1, 1, 2,
	-6, 3,-5,-7,-9,-5,-8,-8,-3,-6,-2,-4,-5, 1,-6,-3,-6, 22,
	-4,-5,-2,-5, 1,-4,-5,-6, 0,-1, 0,-5,-2, 9,-5,-3,-3, 0, 12,
	 0,-3,-2,-2,-2,-2,-2,-1,-2, 4, 2,-2, 2,-1,-1,-1, 0,-7,-3, 5,
	 0, 0, 2, 3,-5, 2, 3, 1, 1,-2,-4, 1,-2,-5, 0, 1, 0,-6,-4,-2, 3,
	 0, 0, 1, 3,-6, 3, 3, 0, 2,-2,-3, 1,-2,-5, 0, 0, 0,-6,-5,-2, 2, 3,
	 0,-1, 0,-1,-3, 0,-1,-1, 0,-1,-1,-1,-1,-2,-1, 0, 0,-4,-2, 0, 0,-1,-1,
	-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9,-9, 1
	};
}
