
/*
 * 
 *  file:  ./src/edu/virginia/bioch/util/Range.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.util;



import java.*;
import java.lang.*;
import java.util.*;


public class Range
{
	protected int begin;
	protected int end;

	public Range( String range )
	{
		System.out.println("Range constructor for: \'" + range + "\'" );

		StringBuffer sb = new StringBuffer( range );
		StringBuffer first = new StringBuffer();
		StringBuffer second = new StringBuffer();
		boolean gotDash = false;

		for ( int i = 0; i < sb.length(); i++ )
		{
			char c = sb.charAt(i);
			if ( c == '-' )
				gotDash = true;
			else if ( !gotDash )
				first.append( c );
			else
				second.append( c );
		}
		
		if ( second.length() > 0 )
		{
			begin = Integer.parseInt( first.toString() );
			end = Integer.parseInt( second.toString() );
		}
		else
		{
			begin = Integer.parseInt( first.toString() );
			end = Integer.parseInt( first.toString() );
		}

		makeSane();
	}

	public Range( int b, int e )
	{
		begin = b;
		end = e;

		makeSane();
	}

	public Range( int x )
	{
		begin = x;
		end = x;
	}

	private void makeSane()
	{
		if ( begin > end )
		{
			int temp = begin;
			begin = end;
			end = temp;
		}
	}

	public boolean inRange( int i )
	{
		if ( i >= begin && i <= end )
			return true;
		else
			return false;
	}

	public int getLength()
	{
		return (end - begin) + 1;
	}

	public boolean sameLength( Range r )
	{
		int rb = r.getBegin();
		int re = r.getEnd();

		if ( (re - rb) == (end - begin) )
			return true;
		else
			return false;
	}

	public int getBegin()
	{ return begin; }

	public int getEnd()
	{ return end; }

	public boolean equals( Object r )
	{
		if ( r == this )
			return true;

		if ( r instanceof Range )
		{
			if ( ((Range)r).getBegin() == begin && 
				 ((Range)r).getEnd() == end )
				return true;
			else
				return false;
		}
		else
			return false;
	}

	public String toSimpleString()
	{ return begin + "-" + end; }

	public String toString()
	{ return "Range begin: " + begin + "   end: " + end; }

	public static java.util.List parseRanges( String rangeString )
	{
		ArrayList l = new ArrayList();
		StringTokenizer st = new StringTokenizer(rangeString,",");	
		while ( st.hasMoreTokens() )
			l.add( new Range( st.nextToken() ) );

		return l;
	}
}
