
/*
 * 
 *  file:  ./test/edu/virginia/bioch/nopt/alignments/EdgeKeyTest.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.alignments;

import junit.framework.*;
import edu.virginia.bioch.nopt.alignments.*;


public class EdgeKeyTest extends TestCase
{
	private EdgeKey ek1;
	private EdgeKey ek2;
	private EdgeKey ek3;

	public EdgeKeyTest( String name )
	{
		super(name);
	}

	public static void main(String args[])
	{
		junit.textui.TestRunner.run( suite() );
	}

	public static Test suite() 
	{
		return new TestSuite( EdgeKeyTest.class );
	}

	protected void setUp()
	{
		ek1 = new EdgeKey(1,2,3,4,'z','y',1.0,0.9,5,"asdf");
		ek2 = new EdgeKey(5,6,3,4,'b','y',1.1,0.8,6,"fdsa");
		ek3 = new EdgeKey();
	}

	public void testEquals()
	{
		EdgeKey ekt = new EdgeKey(1,2,3,4,'z','y',1.0,0.9,5,"asdf");
		assertTrue(ekt.equals(ek1));
		assertTrue(!ekt.equals(ek3));
	}

	public void testHashCode()
	{
		EdgeKey ekt = new EdgeKey(1,2,3,4,'z','y',1.0,0.9,5,"asdf");
		assertTrue( ekt.hashCode() == ek1.hashCode() );
		assertTrue( ekt.hashCode() != ek2.hashCode() );
	}
}
