
/*
 * 
 *  file:  ./test/edu/virginia/bioch/nopt/options/OptionTest.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.nopt.options;

import junit.framework.*;
import edu.virginia.bioch.nopt.options.*;
import edu.virginia.bioch.nopt.alignments.*;


public class OptionTest extends TestCase
{
	private Option opt1;
	private Option opt2;
	private Option opt3;
	private AlignmentHandler ah;

	public OptionTest( String name )
	{
		super(name);
	}

	public static void main(String args[])
	{
		junit.textui.TestRunner.run( suite() );
	}

	public static Test suite() 
	{
		return new TestSuite( OptionTest.class );
	}

	protected void setUp()
	{
		ah = new AlignmentHandler();
		opt1 = new Option("option1","10-20,23-29",Option.getSeq1Id(),"Opt",ah, 
				          ".");
		opt2 = new Option("option1","10-20,23-29",Option.getSeq1Id(),"Opt",ah, 
				          ".");
		opt3 = new Option("option2","11-21,23-29",Option.getSeq2Id(),"Opt",ah, 
				          ".");
	}

	public void testEquals()
	{
		assertTrue(opt1.toString().equals(opt2.toString()));
		assertTrue(!opt1.toString().equals(opt3.toString()));
	}

}
