
/*
 * 
 *  file:  ./test/edu/virginia/bioch/util/FastaReaderTest.java
 * 
 *  Copyright (c) 2004,  the University of Virginia.
 *  All rights reverved.
 * 
 *  See the file COPYRIGHT in the top directory of this distribution for
 *  more information.
 *  
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.  
 *  
 */ 

package edu.virginia.bioch.util;

import junit.framework.*;
import edu.virginia.bioch.util.*;
import java.net.*;
import java.io.*;
import java.util.zip.*;


public class FastaReaderTest extends TestCase
{

	public FastaReaderTest( String name )
	{
		super(name);
	}

	public static void main(String args[])
	{
		junit.textui.TestRunner.run( suite() );
	}

	public static Test suite() 
	{
		return new TestSuite( FastaReaderTest.class );
	}

	private URL goodFileUrl;
	private URL messyFileUrl;
	private URL badFileUrl;

	private String goodFileName;
	private String messyFileName;
	private String badFileName;

	private FastaReader fr;

	// NOTE:  The file/url mess is a result of running the test
	// via ant and through AllTests.java.  Ant uses the filenames while
	// AllTests uses the urls.  This is actually a good thing since it
	// tests both constructors.
	protected void setUp()
	{
		fr = null;

		goodFileName = "examples/good.fasta";	
		messyFileName = "examples/messy.fasta";	
		badFileName = "examples/bad.fasta";	

		goodFileUrl = ClassLoader.getSystemResource( goodFileName );	
		messyFileUrl = ClassLoader.getSystemResource( messyFileName );	
		badFileUrl = ClassLoader.getSystemResource( badFileName );	

	}

	public void testRead() throws IOException, DataFormatException
	{
		if ( goodFileUrl != null )
			fr = new FastaReader( goodFileUrl ); 
		else
			fr = new FastaReader( goodFileName ); 

		assertTrue( fr.getHeader().equals(">good header") );
		assertTrue( fr.getSequence().equals("acgt") );
	}

	public void testMessyRead() throws IOException, DataFormatException
	{
		if ( messyFileUrl != null )
			fr = new FastaReader( messyFileUrl ); 
		else
			fr = new FastaReader( messyFileName ); 

		assertTrue( fr.getHeader().equals(">messy header   	") );
		assertTrue( fr.getSequence().equals("acgt") );
	}

	public void testBadFile() throws DataFormatException
	{
		try {
			fr = new FastaReader("none_existent_file"); 
			fail( "Should raise IOException");
		}
		catch ( IOException e ){ };
	}

	public void testBadFileFormat() throws IOException
	{
		try {
			if ( badFileUrl != null )
				fr = new FastaReader( badFileUrl ); 
			else
				fr = new FastaReader( badFileName ); 

			fail( "Should raise DataFormatException");
		}
		catch ( DataFormatException e ){ };
	}
}
