
DROP DATABASE IF EXISTS seqdb_demo;
CREATE DATABASE seqdb_demo;
GRANT ALL PRIVILEGES ON seqdb_demo.*
      TO seqdb_user@localhost identified by "seqdb_pass";
GRANT ALL PRIVILEGES ON seqdb_demo.*
      TO seqdb_user@"%" identified by "seqdb_pass";
FLUSH PRIVILEGES;
use seqdb_demo;

#
# Table structure for table 'protein'
#

DROP TABLE IF EXISTS protein;
CREATE TABLE protein (
  prot_id int(10) unsigned NOT NULL auto_increment,
  seq text NOT NULL default '',
  len int(10) unsigned NOT NULL default '0',
  pi float NOT NULL default '0',
  mw float NOT NULL default '0',
  PRIMARY KEY  (prot_id),
  KEY len (len),
  KEY pi (pi),
  KEY mw (mw)
) TYPE=MyISAM;

#
# Table structure for table 'annot'
#

DROP TABLE IF EXISTS annot;
CREATE TABLE annot (
  acc char(20) NOT NULL default '',
  ver tinyint unsigned not null default 1,
  gi int(10) unsigned default NULL,
  prot_id int(10) unsigned NOT NULL default '0',
  taxon_id int(10) unsigned default NULL,
  db enum('gb','emb','dbj','prf','ref','pdb','pir','sp','tpg','tr') NOT NULL default 'gb',
  descr text NOT NULL default '',
  pref tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (acc),
  KEY gi (gi),
  KEY prot_id (prot_id),
  KEY taxon_id (taxon_id),
  KEY db (db),
  KEY pref (pref)
) TYPE=MyISAM;

#
# Table structure for table 'annot_dbj'
#

DROP TABLE IF EXISTS annot_dbj;
CREATE TABLE annot_dbj (
  acc char(20) NOT NULL default '',
  ver tinyint unsigned not null default 1,
  dna_acc char(20) NOT NULL default '',
  PRIMARY KEY  (acc, ver)
) TYPE=MyISAM;

#
# Table structure for table 'annot_emb'
#

DROP TABLE IF EXISTS annot_emb;
CREATE TABLE annot_emb (
  acc char(20) NOT NULL default '',
  ver tinyint unsigned not null default 1,
  dna_acc char(20) NOT NULL default '',
  PRIMARY KEY  (acc, ver)
) TYPE=MyISAM;

#
# Table structure for table 'annot_gb'
#

DROP TABLE IF EXISTS annot_gb;
CREATE TABLE annot_gb (
  acc char(20) NOT NULL default '',
  ver tinyint unsigned not null default 1,
  dna_acc char(20) NOT NULL default '',
  PRIMARY KEY  (acc, ver)
) TYPE=MyISAM;

#
# Table structure for table 'annot_ref'
#

DROP TABLE IF EXISTS annot_ref;
CREATE TABLE annot_ref (
  acc char(20) NOT NULL default '',
  ver tinyint unsigned not null default 1,
  dna_acc char(20) NOT NULL default '',
  PRIMARY KEY  (acc, ver)
) TYPE=MyISAM;

#
# Table structure for table 'annot_tpg'
#

DROP TABLE IF EXISTS annot_tpg;
CREATE TABLE annot_tpg (
  acc char(20) NOT NULL default '',
  ver tinyint unsigned not null default 1,
  dna_acc char(20) NOT NULL default '',
  PRIMARY KEY  (acc, ver)
) TYPE=MyISAM;

#
# Table structure for table 'annot_sp'
#

DROP TABLE IF EXISTS annot_sp;
CREATE TABLE annot_sp (
  acc char(20) NOT NULL default '',
  ver tinyint unsigned not null default 1,
  name char(10) NOT NULL default '',
  PRIMARY KEY  (acc, ver),
  KEY name (name)
) TYPE=MyISAM;

#
# Table structure for table 'taxon'
#

DROP TABLE IF EXISTS taxon;
CREATE TABLE taxon (
  taxon_id int(10) unsigned NOT NULL default '0',
  parent_id int(10) unsigned NOT NULL default '0',
  left_id int(10) unsigned NOT NULL default '0',
  right_id int(10) unsigned NOT NULL default '0',
  rank enum('superphylum',
	    'superkingdom',
	    'parvorder',
	    'kingdom',
	    'superclass',
	    'infraclass',
	    'subphylum',
	    'superorder',
	    'infraorder',
	    'forma',
	    'phylum',
	    'species subgroup',
	    'subtribe',
	    'subclass',
	    'class',
	    'species group',
	    'suborder',
	    'subgenus',
	    'tribe',
	    'superfamily',
	    'varietas',
	    'order',
	    'subfamily',
	    'no rank',
	    'subspecies',
	    'family',
	    'genus',
	    'species'
	    ) NOT NULL default 'no rank',
  gc_id int(10) unsigned NOT NULL default '0',
  mgc_id int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (taxon_id),
  KEY parent_id (parent_id),
  KEY left_id (left_id),
  KEY right_id (right_id),
  KEY rank (rank),
  KEY gc_id (gc_id),
  KEY mgc_id (mgc_id)
) TYPE=MyISAM;

#
# Table structure for table 'taxon_gc'
#

DROP TABLE IF EXISTS taxon_gc;
CREATE TABLE taxon_gc (
  gc_id int(10) unsigned NOT NULL default '0',
  name tinytext,
  cde varchar(64) default NULL,
  starts varchar(64) default NULL,
  PRIMARY KEY  (gc_id)
) TYPE=MyISAM;

#
# Table structure for table 'taxon_name'
#

DROP TABLE IF EXISTS taxon_name;
CREATE TABLE taxon_name (
  id int(10) unsigned NOT NULL auto_increment,
  taxon_id int(10) unsigned NOT NULL default '0',
  name text NOT NULL,
  class enum('acronym',
             'anamorph',
	     'blast name',
	     'common name',
	     'equivalent name',
	     'in-part',
	     'includes',
	     'misnomer',
	     'misspelling',
	     'preferred acronym',
	     'preferred common name',
	     'scientific name',
	     'synonym',
	     'teleomorph'
	     ) NOT NULL default 'common name',
  PRIMARY KEY  (id),
  KEY taxon_id (taxon_id),
  KEY class (class)
) TYPE=MyISAM;

#
# Table structure for table 'annot_old'
#

DROP TABLE IF EXISTS annot_old;
CREATE TABLE annot_old (
  acc char(20) NOT NULL default '',
  ver tinyint unsigned not null default 1,
  gi int(10) unsigned default NULL,
  prot_id int(10) unsigned NOT NULL default '0',
  taxon_id int(10) unsigned default NULL,
  db enum('gb','emb','dbj','prf','ref','pdb','pir','sp','tpg','tr') NOT NULL default 'gb',
  descr text NOT NULL default '',
  PRIMARY KEY  (acc, ver),
  KEY gi (gi),
  KEY prot_id (prot_id),
  KEY taxon_id (taxon_id),
  KEY db (db)
) TYPE=MyISAM;

# MySQL dump 8.16
#
# Host: xdb    Database: seqdb
#--------------------------------------------------------
# Server version	3.23.47

#
# Table structure for table 'go'
#

CREATE TABLE go (
  go_acc varchar(10) NOT NULL default '',
  name text NOT NULL,
  PRIMARY KEY  (go_acc),
  KEY acc (go_acc)
) TYPE=MyISAM;

#
# Table structure for table 'go_edge'
#

CREATE TABLE go_edge (
  child char(10) NOT NULL default '',
  parent char(10) NOT NULL default '',
  type enum('isa','partof') NOT NULL default 'isa',
  PRIMARY KEY  (child,parent)
) TYPE=MyISAM;

#
# Table structure for table 'go_assoc'
#

CREATE TABLE go_assoc (
  go_acc char(10) NOT NULL default '',
  acc char(10) NOT NULL default '',
  evidence enum('IMP','IGI','IPI','ISS','IDA','IEP','IEA','TAS','NAS','NR') NOT NULL default 'NR',
  aspect enum('P','F','C') NOT NULL default 'P',
  db enum('sp','gb','emb','dbj','tr') NOT NULL default 'sp',
  gi int(10) unsigned default NULL,
  PRIMARY KEY  (go_acc,acc,db,evidence)
) TYPE=MyISAM;

#
# Table structure for table 'go_synonym'
#

CREATE TABLE go_synonym (
  go_acc char(10) NOT NULL default '',
  syn_acc char(10) NOT NULL default '',
  PRIMARY KEY  (go_acc,syn_acc),
  KEY acc (go_acc),
  KEY syn (syn_acc)
) TYPE=MyISAM;

